/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class VersionLabelsEditor
extends DefaultEditor {
    private final String path;
    private final ReadWriteVersionManager vMgr;

    VersionLabelsEditor(String labelsPath, ReadWriteVersionManager versionManager) {
        this.path = labelsPath;
        this.vMgr = versionManager;
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.validateLabel(after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.validateLabel(after);
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return (Editor)Utils.throwProtected(PathUtils.concat((String)this.path, (String)name));
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return (Editor)Utils.throwProtected(PathUtils.concat((String)this.path, (String)name));
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return (Editor)Utils.throwProtected(PathUtils.concat((String)this.path, (String)name));
    }

    private void validateLabel(PropertyState label) throws CommitFailedException {
        String identifier = (String)label.getValue(Type.REFERENCE);
        Tree version = this.vMgr.getVersion(identifier);
        if (version == null) {
            throw new CommitFailedException("Constraint", 0, "Version label references unknown node");
        }
        String parent = PathUtils.getAncestorPath((String)this.path, (int)1);
        String versionName = version.getName();
        if (versionName.equals("jcr:rootVersion") || !PathUtils.isAncestor((String)parent, (String)version.getPath())) {
            throw new CommitFailedException("Version", VersionExceptionCode.NO_SUCH_VERSION.ordinal(), "Not a valid version on this history: " + versionName);
        }
    }
}

