/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.diffindex;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.diffindex.BaseDiffCollector;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class UUIDDiffCollector
extends BaseDiffCollector {
    private String uuid;

    public UUIDDiffCollector(NodeState before, NodeState after) {
        super(before, after);
    }

    @Override
    public void collect(Filter filter) {
        this.uuid = null;
        Filter.PropertyRestriction restriction = filter.getPropertyRestriction("jcr:uuid");
        if (restriction == null || restriction.isLike || !restriction.firstIncluding || !restriction.lastIncluding || !restriction.first.equals(restriction.last)) {
            this.init = true;
            return;
        }
        this.uuid = restriction.first.toString();
        super.collect(filter);
    }

    private static String extractUuidFromFilter(Filter filter) {
        Filter.PropertyRestriction restriction = filter.getPropertyRestriction("jcr:uuid");
        return restriction.first.toString();
    }

    @Override
    public Set<String> getResults(Filter filter) {
        if (this.init && !UUIDDiffCollector.extractUuidFromFilter(filter).equals(this.uuid)) {
            throw new IllegalArgumentException("UUID does not match ");
        }
        return super.getResults(filter);
    }

    @Override
    protected boolean match(NodeState state, Filter filter) {
        if (this.uuid == null) {
            return false;
        }
        PropertyState propertyState = state.getProperty("jcr:uuid");
        return propertyState != null && this.uuid.equals(propertyState.getValue(Type.STRING));
    }

    @Override
    protected boolean isUnique() {
        return true;
    }
}

