/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class CompositeIndexEditorProvider
implements IndexEditorProvider {
    private final List<IndexEditorProvider> providers;

    @NotNull
    public static IndexEditorProvider compose(IndexEditorProvider ... providers) {
        switch (providers.length) {
            case 0: {
                return (type, builder, root, callback) -> null;
            }
            case 1: {
                return providers[0];
            }
        }
        return new CompositeIndexEditorProvider(providers);
    }

    @NotNull
    public static IndexEditorProvider compose(@NotNull List<IndexEditorProvider> providers) {
        switch (providers.size()) {
            case 0: {
                return (type, builder, root, callback) -> null;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeIndexEditorProvider(providers);
    }

    private CompositeIndexEditorProvider(List<IndexEditorProvider> providers) {
        this.providers = providers;
    }

    public CompositeIndexEditorProvider(IndexEditorProvider ... providers) {
        this(Arrays.asList(providers));
    }

    @Override
    public Editor getIndexEditor(@NotNull String type, @NotNull NodeBuilder builder, @NotNull NodeState root, @NotNull IndexUpdateCallback callback) throws CommitFailedException {
        ArrayList<Editor> indexes = new ArrayList<Editor>(this.providers.size());
        for (IndexEditorProvider provider : this.providers) {
            Editor e = provider.getIndexEditor(type, builder, root, callback);
            if (e == null) continue;
            indexes.add(e);
        }
        return CompositeEditor.compose(indexes);
    }

    @Override
    public void close() throws IOException {
        for (IndexEditorProvider provider : this.providers) {
            provider.close();
        }
    }
}

