/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import java.text.MessageFormat;
import java.util.UUID;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.jcr.webdav.WebDavContext;
import org.silverpeas.kernel.cache.model.Cache;
import org.silverpeas.kernel.util.StringUtil;

public class WebDavTokenGenerator {
    private static final String DOCUMENT_TOKEN_PATTERN = "webdav-token:{0}:{1}";
    private final User user;

    public static WebDavTokenGenerator getFor(User user) {
        return new WebDavTokenGenerator(user);
    }

    private WebDavTokenGenerator(User user) {
        this.user = user;
    }

    public String generateToken(String documentId) {
        String token = WebDavTokenGenerator.generateToken();
        Cache cache = WebDavTokenGenerator.getCache();
        cache.put((Object)token, (Object)this.user);
        String documentTokenKey = MessageFormat.format(DOCUMENT_TOKEN_PATTERN, this.user.getId(), documentId);
        cache.put((Object)documentTokenKey, (Object)token);
        return token;
    }

    public void deleteToken(String documentId) throws IllegalArgumentException {
        String documentTokenKey;
        Cache cache = WebDavTokenGenerator.getCache();
        String token = (String)cache.get((Object)(documentTokenKey = MessageFormat.format(DOCUMENT_TOKEN_PATTERN, this.user.getId(), documentId)));
        if (token != null) {
            User actualUser = (User)cache.get((Object)token);
            if (actualUser == null || !actualUser.getId().equals(this.user.getId())) {
                throw new IllegalArgumentException("No token for user " + this.user.getId() + " to access document " + documentId);
            }
            WebDavContext.clearWebDavContext(token);
            cache.remove((Object)token);
            cache.remove((Object)documentTokenKey);
        }
    }

    private static String generateToken() {
        String[] parts = UUID.randomUUID().toString().split("-");
        return StringUtil.asBase64((byte[])parts[parts.length - 1].getBytes());
    }

    private static Cache getCache() {
        return CacheAccessorProvider.getApplicationCacheAccessor().getCache();
    }
}

