/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.configuration;

import java.util.Properties;
import org.silverpeas.core.jcr.impl.oak.configuration.NodeStoreConfiguration;

public class SegmentNodeStoreConfiguration
extends NodeStoreConfiguration {
    SegmentNodeStoreConfiguration(Properties props) {
        super(props);
    }

    public String getStoragePath() {
        return this.getString("segment.repository", "segmentstore");
    }

    public int getTarMaxSize() {
        return this.getInteger("segment.tar.size", 256);
    }

    public int getSegmentCacheSize() {
        return this.getInteger("segment.cache.size", 256);
    }

    public int getStringCacheSize() {
        return this.getInteger("segment.string.cache.size", 256);
    }

    public int getTemplateCacheSize() {
        return this.getInteger("segment.template.cache.size", 64);
    }

    public int getStringDeduplicationCacheSize() {
        return this.getInteger("segment.string.deduplicationCache.size", 15000);
    }

    public int getTemplateDeduplicationCacheSize() {
        return this.getInteger("segment.template.deduplicationCache.size", 3000);
    }

    public int getNodeDeduplicationCacheSize() {
        return this.getInteger("segment.node.deduplicationCache.size", 0x100000);
    }

    public boolean isPauseCompaction() {
        return this.getBoolean("segment.compaction.pause", false);
    }

    public String getCompactionCRON() {
        return this.getString("segment.compaction.cron", "");
    }

    public int getBackupFileAgeThreshold() {
        return this.getInteger("segment.compaction.backup.age", -1);
    }

    public int getCompactionRetryCount() {
        return this.getInteger("segment.compaction.retryCount", 5);
    }

    public int getCompactionForceTimeout() {
        return this.getInteger("segment.compaction.forceTimeout", 60);
    }

    public long getCompactionSizeDeltaEstimation() {
        return this.getLong("segment.compaction.sizeDeltaEstimation", 0x40000000L);
    }

    public boolean isCompactionDisableEstimation() {
        return this.getBoolean("segment.compaction.disableEstimation", false);
    }

    public int getCompactionMemoryThreshold() {
        return this.getInteger("segment.compaction.memoryThreshold", 15);
    }

    public long getCompactionProgressLog() {
        return this.getLong("segment.compaction.progressLog", -1L);
    }

    public static class DefaultValues {
        public static final int MAX_TAR_SIZE = 256;
        public static final int SEGMENT_CACHE_SIZE = 256;
        public static final int STRING_CACHE_SIZE = 256;
        public static final int TEMPLATE_CACHE_SIZE = 64;
        public static final int STRING_DEDUPLICATION_CACHE_SIZE = 15000;
        public static final int TEMPLATE_DEDUPLICATION_CACHE_SIZE = 3000;
        public static final int NODE_DEDUPLICATION_CACHE_SIZE = 0x100000;
        public static final boolean COMPACTION_PAUSE = false;
        public static final String COMPACTION_CRON = "";
        public static final int COMPACTION_BACKUP_FILE_AGE_THRESHOLD = -1;
        public static final int COMPACTION_RETRY_COUNT = 5;
        public static final int COMPACTION_FORCE_TIMEOUT = 60;
        public static final long COMPACTION_SIZE_DELTA_ESTIMATION = 0x40000000L;
        public static final boolean COMPACTION_DISABLE_ESTIMATION = false;
        public static final int COMPACTION_MEMORY_THRESHOLD = 15;
        public static final long COMPACTION_PROGRESS_LOG = -1L;

        private DefaultValues() {
        }
    }
}

