/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormatRegistryException;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;

public final class DefaultDocumentFormatRegistryInstanceHolder {
    private static DocumentFormatRegistry instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull DocumentFormatRegistry getInstance() {
        Class<DocumentFormatRegistry> clazz = DocumentFormatRegistry.class;
        synchronized (DocumentFormatRegistry.class) {
            if (instance == null) {
                JsonDocumentFormatRegistry defaultRegistry = DefaultDocumentFormatRegistryInstanceHolder.loadRegistry("/document-formats.json");
                if (defaultRegistry == null) {
                    throw new DocumentFormatRegistryException("Could not load the default document-formats.json configuration file");
                }
                defaultRegistry.addRegistry(DefaultDocumentFormatRegistryInstanceHolder.loadRegistry("/custom-document-formats.json"));
                instance = defaultRegistry;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(DocumentFormatRegistry registry) {
        Class<DocumentFormatRegistry> clazz = DocumentFormatRegistry.class;
        synchronized (DocumentFormatRegistry.class) {
            instance = registry;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonDocumentFormatRegistry loadRegistry(String name) {
        try (InputStream input = DefaultDocumentFormatRegistryInstanceHolder.class.getResourceAsStream(name);){
            if (input == null) return null;
            JsonDocumentFormatRegistry jsonDocumentFormatRegistry = JsonDocumentFormatRegistry.create(input);
            return jsonDocumentFormatRegistry;
        }
        catch (IOException ex) {
            throw new DocumentFormatRegistryException("Could not load the configuration file: " + name, ex);
        }
    }

    private DefaultDocumentFormatRegistryInstanceHolder() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

