/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Crypt;
import net.sourceforge.jcetaglib.test.RunTest;

public class CryptTest
extends TestCase {
    private StringBuffer ciphertext = null;
    private StringBuffer plaintext = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testBlockCipher() throws Exception {
        for (int i = 0; i < RunTest.alg.length; ++i) {
            for (int j = 0; j < RunTest.modes.length; ++j) {
                for (int k = 0; k < RunTest.padding.length; ++k) {
                    for (int l = 0; l < RunTest.text.length; ++l) {
                        if (RunTest.padding[k].equalsIgnoreCase("WithCTS") && (RunTest.modes[j].equalsIgnoreCase("OFB8") || RunTest.modes[j].equalsIgnoreCase("CFB8"))) continue;
                        String keyfile = "C:/tmp/" + RunTest.alg[i][0] + "_" + RunTest.alg[i][1] + ".key";
                        this.ciphertext = Crypt.encrypt(RunTest.text[l], keyfile, new StringBuffer("password"), RunTest.alg[i][0], RunTest.modes[j], RunTest.padding[k], null);
                        this.plaintext = Crypt.decrypt(this.ciphertext, keyfile, new StringBuffer("password"), RunTest.alg[i][0], RunTest.modes[j], RunTest.padding[k]);
                        Assert.assertEquals((String)this.plaintext.toString(), (String)RunTest.text[l].toString());
                    }
                }
            }
        }
    }

    public void testFileBlockCipher() throws Exception {
        for (int i = 0; i < RunTest.alg.length; ++i) {
            for (int j = 0; j < RunTest.modes.length; ++j) {
                for (int k = 0; k < RunTest.padding.length; ++k) {
                    int c;
                    if (RunTest.padding[k].equalsIgnoreCase("WithCTS") && (RunTest.modes[j].equalsIgnoreCase("OFB8") || RunTest.modes[j].equalsIgnoreCase("CFB8"))) continue;
                    String keyfile = "C:/tmp/" + RunTest.alg[i][0] + "_" + RunTest.alg[i][1] + ".key";
                    Crypt.encryptFile("C:/tmp/readable.txt", "C:/tmp/readable.txt.encrypted", keyfile, new StringBuffer("password"), RunTest.alg[i][0], RunTest.modes[j], RunTest.padding[k], null);
                    Crypt.decryptFile("C:/tmp/readable.txt.encrypted", "C:/tmp/readable.txt.decrypted", keyfile, new StringBuffer("password"), RunTest.alg[i][0], RunTest.modes[j], RunTest.padding[k]);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("C:/tmp/readable.txt.decrypted")));
                    StringBuffer line = new StringBuffer();
                    while ((c = reader.read()) != -1) {
                        line.append((char)c);
                    }
                    reader.close();
                    String t = line.toString();
                    Assert.assertEquals((String)"This is a readable string inside a file", (String)t);
                }
            }
        }
    }
}

