/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Signatures {
    private static int BUFFERSIZE_TEXT = 64;
    private static int BUFFERSIZE_FILE = 8192;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer generateSIG(StringBuffer text, PrivateKey signingKey, String signame) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Signatures.generateSIG(new ByteArrayInputStream(text.toString().getBytes()), dao, signingKey, signame, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var7_7 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static StringBuffer generateFileSIG(String file, PrivateKey signingKey, String signame) throws CryptoException {
        IOException e22;
        StringBuffer stringBuffer;
        FilterOutputStream dao;
        FileInputStream fis;
        block12: {
            fis = null;
            ByteArrayOutputStream bao = null;
            dao = null;
            fis = new FileInputStream(file);
            bao = new ByteArrayOutputStream();
            dao = new DataOutputStream(bao);
            Signatures.generateSIG(fis, (DataOutputStream)dao, signingKey, signame, BUFFERSIZE_FILE);
            stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
            Object var8_8 = null;
            if (dao == null) break block12;
            try {
                dao.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        return stringBuffer;
        catch (IOException ioe) {
            try {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
            catch (Throwable throwable) {
                block14: {
                    IOException e22;
                    Object var8_9 = null;
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block14;
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {}
                }
                throw throwable;
            }
        }
    }

    public static void generateSIG(InputStream is, DataOutputStream daos, PrivateKey signingKey, String signame, int bufferlength) throws CryptoException, IOException {
        Signature sig = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            sig = Signature.getInstance(signame, "BC");
            sig.initSign(signingKey);
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                sig.update(buffer, 0, length);
            }
            byte[] result = sig.sign();
            daos.write(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }

    public static boolean verifySIG(StringBuffer text, StringBuffer signature, PublicKey verifyKey, String signame) throws CryptoException {
        try {
            return Signatures.verifySIG(new ByteArrayInputStream(text.toString().getBytes()), signature, verifyKey, signame, BUFFERSIZE_TEXT);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new CryptoException(ioe.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyFileSIG(String file, StringBuffer signature, PublicKey verifyKey, String signame) throws CryptoException {
        boolean bl;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                bl = Signatures.verifySIG(fis, signature, verifyKey, signame, BUFFERSIZE_FILE);
                Object var7_7 = null;
                if (fis == null) return bl;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return bl;
        }
        fis.close();
        return bl;
    }

    public static boolean verifySIG(InputStream is, StringBuffer signature, PublicKey verifyKey, String signame, int bufferlength) throws CryptoException, IOException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Signature sig = Signature.getInstance(signame, "BC");
            byte[] sigBytes = Base64.decode((String)signature.toString());
            sig.initVerify(verifyKey);
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                sig.update(buffer, 0, length);
            }
            return sig.verify(sigBytes);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }
}

