/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.security.session.SilverpeasUserSession;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.wbe.DefaultWbeUser;
import org.silverpeas.core.wbe.WbeCache;
import org.silverpeas.core.wbe.WbeClientManager;
import org.silverpeas.core.wbe.WbeEdition;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.core.wbe.WbeLogger;
import org.silverpeas.core.wbe.WbeUser;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.Pair;

@Service
public class DefaultWbeHostManager
implements WbeHostManager {
    private final WbeCache cache = new WbeCache();
    private final List<WbeClientManager> clients = new ArrayList<WbeClientManager>();
    private boolean enabled = true;

    protected DefaultWbeHostManager() {
    }

    @PostConstruct
    protected void init() {
        this.clients.addAll(ServiceProvider.getAllServices(WbeClientManager.class, (Annotation[])new Annotation[0]));
    }

    public List<Pair<String, String>> getClientAdministrationAccesses(String language) {
        return this.getEnabledClients().flatMap(m -> m.getAdministrationUrl().stream().map(u -> Pair.of((Object)m.getName(language), (Object)u))).collect(Collectors.toList());
    }

    public void notifyEditionWith(WbeFile file, Set<String> userIds) {
        if (this.isEnabled()) {
            WbeLogger.logger().debug(() -> MessageFormat.format("File {0} is currently edited by {1}", file, userIds));
            this.cache.registerEdition(file, userIds);
        }
    }

    public List<WbeFile> getEditedFilesBy(WbeUser user) {
        return this.cache.getEditedFilesBy(user);
    }

    public List<WbeUser> getEditorsOfFile(WbeFile file) {
        return this.cache.getEditorsOfFile(file);
    }

    public void enable(boolean enable) {
        this.enabled = enable;
        if (!enable) {
            this.clear();
        }
    }

    public boolean isEnabled() {
        return this.getEnabledClients().findAny().isPresent();
    }

    public boolean isHandled(WbeFile file) {
        try {
            return this.getClientFor(file).isPresent();
        }
        catch (WebApplicationException e) {
            return false;
        }
    }

    public <T extends WbeEdition> Optional<T> prepareEditionWith(SilverpeasUserSession spUserSession, WbeFile anyFile) {
        String spUserSessionId = spUserSession.getId();
        if (this.isHandled(anyFile)) {
            WbeUser user = this.cache.computeUserIfAbsent(spUserSessionId, () -> new DefaultWbeUser(spUserSession));
            WbeFile file = this.cache.computeFileIfAbsent(anyFile);
            user.setLastEditionDateAtNow();
            file.setLastEditionDateAtNow();
            return this.getClientFor(file).flatMap(c -> c.prepareEditionWith(user, file));
        }
        WbeLogger.logger().debug(() -> MessageFormat.format("from {0} preparing WBE edition for {1} and for user {2} but WBE is not enabled!!!", spUserSessionId, anyFile, spUserSession.getUser().getId()));
        return Optional.empty();
    }

    public <R> R getEditionContextFrom(String fileId, String accessToken, BiFunction<Optional<WbeUser>, Optional<WbeFile>, R> contextInitializer) {
        Optional<WbeFile> file = this.cache.getFileFromId(fileId);
        Optional<Pair<String, WbeUser>> user = this.cache.getFileFromAccessToken(accessToken);
        user.ifPresent(p -> {
            SessionInfo sessionInfo = SessionManagementProvider.getSessionManagement().getSessionInfo((String)p.getFirst());
            if (sessionInfo.isDefined() && !sessionInfo.isAnonymous()) {
                sessionInfo.updateLastAccess();
            }
        });
        WbeLogger.logger().debug(() -> MessageFormat.format("getting edition context from {0} and {1}", user, file));
        return contextInitializer.apply(user.map(Pair::getSecond), file);
    }

    public void revokeUser(WbeUser user) {
        if (this.isEnabled()) {
            this.cache.removeUser(user);
        }
    }

    public void revokeFile(WbeFile file) {
        if (this.isEnabled()) {
            this.cache.removeFile(file);
        }
    }

    public List<WbeUser> listCurrentUsers() {
        return this.cache.listAllUsers();
    }

    public List<WbeFile> listCurrentFiles() {
        return this.cache.listAllFiles();
    }

    public void clear() {
        this.cache.clear();
        this.clients.forEach(WbeClientManager::clear);
    }

    private Stream<WbeClientManager> getEnabledClients() {
        return this.enabled ? this.clients.stream().filter(WbeClientManager::isEnabled) : Stream.empty();
    }

    private Optional<WbeClientManager> getClientFor(WbeFile file) {
        return this.getEnabledClients().filter(c -> c.isHandled(file)).findFirst();
    }

    @Technical
    @Bean
    public static class WbeCacheCleanerJob
    extends Job
    implements Initialization {
        private static final String WBE_CLEANER_JOB_NAME = "WbeCleanerJob";
        @Inject
        private Scheduler scheduler;
        @Inject
        private DefaultWbeHostManager manager;

        private WbeCacheCleanerJob() {
            super(WBE_CLEANER_JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            WbeLogger.logger().debug(() -> "executing Web Browser Edition cleaner JOB");
            OffsetDateTime offset = OffsetDateTime.now().minusHours(8L);
            this.manager.cache.clearAllBefore(offset);
        }

        public void init() throws SchedulerException {
            WbeLogger.logger().debug(() -> "initializing Web Browser Edition cleaner JOB");
            this.scheduler.unscheduleJob(WBE_CLEANER_JOB_NAME);
            this.scheduler.scheduleJob((Job)this, JobTrigger.triggerEvery((int)5, (TimeUnit)TimeUnit.MINUTE));
        }
    }
}

