/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.memory.MemoryUnit;
import org.silverpeas.kernel.SilverpeasResourcesLocation;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class FileRepositoryManager {
    private static final SettingBundle generalSettings = ResourceLocator.getGeneralSettingBundle();
    private static final SettingBundle uploadSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.uploads.uploadSettings");
    private static final String CONTEXT_TOKEN = ",";

    private static Path getDomainPropertiesFolderPath() {
        return SilverpeasResourcesLocation.getInstance().getConfigurationFilesRootPath().resolve(Path.of("org", "silverpeas", "domains"));
    }

    private static Path getDomainAuthPropertiesFolderPath() {
        return SilverpeasResourcesLocation.getInstance().getConfigurationFilesRootPath().resolve(Path.of("org", "silverpeas", "authentication"));
    }

    public static String getSecurityDirPath() {
        return generalSettings.getString("securityPath") + File.separator;
    }

    public static String getInitDataDirPath() {
        return FileRepositoryManager.getUploadPath() + File.separator + "init";
    }

    public static String getAbsolutePath(String sComponentId) {
        return FileRepositoryManager.getUploadPath() + sComponentId + File.separatorChar;
    }

    public static String getAvatarPath() {
        return generalSettings.getString("avatar.path", FileRepositoryManager.getUploadPath() + "avatar");
    }

    public static String getUploadPath() {
        return generalSettings.getString("uploadsPath") + File.separatorChar;
    }

    public static String getAbsolutePath(String componentId, String[] relativeDirectoryPath) {
        StringBuilder path = new StringBuilder(FileRepositoryManager.getAbsolutePath(componentId));
        for (String s : relativeDirectoryPath) {
            path.append(s).append(File.separatorChar);
        }
        return path.toString();
    }

    public static String getTemporaryPath() {
        return generalSettings.getString("tempPath") + File.separatorChar;
    }

    public static String getDomainPropertiesPath(String domainName) {
        Path path = FileRepositoryManager.getDomainPropertiesFolderPath();
        return path.resolve("domain" + domainName + ".properties").toString();
    }

    public static String getDomainAuthenticationPropertiesPath(String domainName) {
        Path path = FileRepositoryManager.getDomainAuthPropertiesFolderPath();
        return path.resolve("autDomain" + domainName + ".properties").toString();
    }

    public static void createAbsolutePath(String componentId, String directoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getAbsolutePath(componentId) + directoryName);
    }

    public static void createGlobalTempPath(String sDirectoryName) {
        FileFolderManager.createFolder(FileRepositoryManager.getTemporaryPath() + sDirectoryName);
    }

    public static void deleteAbsolutePath(String sComponentId, String sDirectoryName) {
        FileFolderManager.deleteFolder(FileRepositoryManager.getAbsolutePath(sComponentId) + sDirectoryName);
    }

    public static String getFileIcon(String extension) {
        return FileRepositoryManager.getFileIcon(false, extension);
    }

    public static String getFileIcon(boolean small, String filename) {
        Object fileIcon;
        String path = URLUtil.getApplicationURL() + uploadSettings.getString("FileIconsPath");
        String extension = StringUtil.defaultStringIfNotDefined((String)FilenameUtils.getExtension((String)filename), (String)filename);
        extension = StringUtil.defaultStringIfNotDefined((String)extension);
        try {
            fileIcon = uploadSettings.getString(extension.toLowerCase(Locale.getDefault()));
        }
        catch (MissingResourceException mre) {
            fileIcon = uploadSettings.getString("unknown");
        }
        if (small && fileIcon != null) {
            fileIcon = ((String)fileIcon).substring(0, ((String)fileIcon).lastIndexOf(".gif")) + "Small.gif";
        }
        return path + (String)fileIcon;
    }

    public static String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    public static String formatFileSize(long lSize) {
        return UnitUtil.formatMemSize((long)lSize);
    }

    public static long getFileSize(String sourceFile) {
        return new File(sourceFile).length();
    }

    public static <T> long getDirectorySize(Collection<T> directories) {
        long size;
        block3: {
            size = 0L;
            List directorySizes = directories.stream().map(d -> () -> FileRepositoryManager.getDirectorySize(FileRepositoryManager.toPath(d))).collect(Collectors.toList());
            try {
                List result = ManagedThreadPool.getPool().invoke(directorySizes, ManagedThreadPool.ExecutionConfig.maxThreadPoolSizeOf((int)Runtime.getRuntime().availableProcessors()));
                for (Future future : result) {
                    size += ((Long)future.get()).longValue();
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger(FileRepositoryManager.class).error((Throwable)e);
                if (!(e instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
        return size;
    }

    public static <T> long getDirectorySize(T directory) {
        FileSizeCounter sizeCounter = new FileSizeCounter();
        try {
            Files.walkFileTree(FileRepositoryManager.toPath(directory), sizeCounter);
        }
        catch (IOException e) {
            SilverLogger.getLogger(FileRepositoryManager.class).error((Throwable)e);
        }
        return sizeCounter.getSize();
    }

    private static <T> Path toPath(T path) {
        if (path instanceof Path) {
            return (Path)path;
        }
        if (path instanceof File) {
            return ((File)path).toPath();
        }
        return Paths.get(path.toString(), new String[0]);
    }

    public static String getFileDownloadTime(long size) {
        int fileSizeReference = Integer.parseInt(uploadSettings.getString("FileSizeReference"));
        int theoreticDownloadTime = Integer.parseInt(uploadSettings.getString("DownloadTime"));
        long fileDownloadEstimation = size * (long)theoreticDownloadTime / (long)fileSizeReference / 60L;
        if (fileDownloadEstimation < 1L) {
            return "t < 1 min";
        }
        if (fileDownloadEstimation < 5L) {
            return "1 < t < 5 mins";
        }
        return " t > 5 mins";
    }

    public static long getUploadMaximumFileSize() {
        return uploadSettings.getLong("MaximumFileSize", UnitUtil.convertTo((long)10L, (MemoryUnit)MemoryUnit.MB, (MemoryUnit)MemoryUnit.B));
    }

    public static void copyFile(String from, String to) throws IOException {
        FileUtils.copyFile((File)new File(from), (File)new File(to));
    }

    public static String formatFileUploadTime(long time) {
        String min = " m";
        String sec = " s";
        String ms = " ms";
        if (time < 1000L) {
            return time + ms;
        }
        if (time < 120000L) {
            return time / 1000L + sec;
        }
        return time / 60000L + min;
    }

    public static String[] getAttachmentContext(String str) {
        String strAt = "Attachment ,";
        if (str != null) {
            strAt = strAt.concat(str);
        }
        StringTokenizer strToken = new StringTokenizer(strAt, CONTEXT_TOKEN);
        int nElt = strToken.countTokens();
        String[] context = new String[nElt];
        int k = 0;
        while (strToken.hasMoreElements()) {
            context[k] = ((String)strToken.nextElement()).trim();
            ++k;
        }
        return context;
    }

    public static String getExportTemplateRepository() {
        Object path = generalSettings.getString("exportTemplatePath");
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    private FileRepositoryManager() {
    }

    private static class FileSizeCounter
    implements FileVisitor<Path> {
        private long size = 0L;

        private FileSizeCounter() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Objects.requireNonNull(file);
            this.size += attrs.size();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        long getSize() {
            return this.size;
        }
    }
}

