/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.silverpeas.core.util.DocumentInfo;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public class PdfUtil {
    private static final String PDF_FILE_ERROR_MSG = "The pdf source file doesn't exist";
    private static final String NOT_PDF_FILE_ERROR_MSG = "The source is not a pdf file";
    private static final String PDF_DESTINATION_ERROR_MSG = "The pdf destination file is unknown";

    private PdfUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static DocumentInfo getDocumentInfo(File pdfSource) {
        if (pdfSource == null || !pdfSource.isFile()) {
            throw new SilverpeasRuntimeException(PDF_FILE_ERROR_MSG);
        }
        if (!FileUtil.isPdf(pdfSource.getPath())) {
            throw new SilverpeasRuntimeException(NOT_PDF_FILE_ERROR_MSG);
        }
        try (PdfReader reader = null;){
            DocumentInfo documentInfo;
            block16: {
                FileInputStream pdfSourceIS = FileUtils.openInputStream((File)pdfSource);
                try {
                    reader = new PdfReader((InputStream)pdfSourceIS);
                    DocumentInfo documentInfo2 = new DocumentInfo();
                    documentInfo2.setNbPages(reader.getNumberOfPages());
                    for (int i = 1; i <= documentInfo2.getNbPages(); ++i) {
                        Rectangle rectangle = reader.getPageSize(i);
                        int maxWidth = Math.round(rectangle.getWidth());
                        int maxHeight = Math.round(rectangle.getHeight());
                        if (maxWidth > documentInfo2.getMaxWidth()) {
                            documentInfo2.setMaxWidth(maxWidth);
                        }
                        if (maxHeight <= documentInfo2.getMaxHeight()) continue;
                        documentInfo2.setMaxHeight(maxHeight);
                    }
                    documentInfo = documentInfo2;
                    if (pdfSourceIS == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (pdfSourceIS != null) {
                            try {
                                ((InputStream)pdfSourceIS).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger(PdfUtil.class).error((Throwable)e);
                        throw new SilverpeasRuntimeException("A problem has occurred during the reading of a pdf file", (Throwable)e);
                    }
                }
                ((InputStream)pdfSourceIS).close();
            }
            return documentInfo;
        }
    }

    public static void firstPageAsImage(File pdfSource, File imageDestination) {
        if (pdfSource == null || !pdfSource.isFile()) {
            throw new SilverpeasRuntimeException(PDF_FILE_ERROR_MSG);
        }
        if (!FileUtil.isPdf(pdfSource.getPath())) {
            throw new SilverpeasRuntimeException(NOT_PDF_FILE_ERROR_MSG);
        }
        try (PDDocument document = PDDocument.load((File)pdfSource);){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage image = pdfRenderer.renderImage(0);
            ImageIO.write((RenderedImage)image, "jpg", imageDestination);
        }
        catch (Exception e) {
            SilverLogger.getLogger(PdfUtil.class).error((Throwable)e);
            throw new SilverpeasRuntimeException("A problem has occurred during the adding of an image into a pdf file", (Throwable)e);
        }
    }

    public static void stamp(File pdfSource, File stampImage, File pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, stampImage, pdfDestination, false);
    }

    public static void stamp(InputStream pdfSource, File stampImage, OutputStream pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, stampImage, pdfDestination, false);
    }

    public static void watermark(File pdfSource, File watermarkImage, File pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, watermarkImage, pdfDestination, true);
    }

    public static void watermark(InputStream pdfSource, File watermarkImage, OutputStream pdfDestination) {
        PdfUtil.addImageOnEachPage(pdfSource, watermarkImage, pdfDestination, true);
    }

    private static void addImageOnEachPage(File pdfSource, File image, File pdfDestination, boolean isBackground) {
        if (pdfSource == null || !pdfSource.isFile()) {
            throw new SilverpeasRuntimeException(PDF_FILE_ERROR_MSG);
        }
        if (!FileUtil.isPdf(pdfSource.getPath())) {
            throw new SilverpeasRuntimeException(NOT_PDF_FILE_ERROR_MSG);
        }
        if (pdfDestination == null) {
            throw new SilverpeasRuntimeException(PDF_DESTINATION_ERROR_MSG);
        }
        try (FileInputStream pdfSourceIS = FileUtils.openInputStream((File)pdfSource);
             FileOutputStream pdfDestinationIS = FileUtils.openOutputStream((File)pdfDestination);){
            PdfUtil.addImageOnEachPage(pdfSourceIS, image, pdfDestinationIS, isBackground);
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException("Pdf source file cannot be opened or pdf destination file cannot be created", (Throwable)e);
        }
    }

    private static void addImageOnEachPage(InputStream pdfSource, File imageToAdd, OutputStream pdfDestination, boolean isBackground) {
        if (imageToAdd == null || !imageToAdd.isFile()) {
            throw new SilverpeasRuntimeException("The image file doesn't exist");
        }
        if (!FileUtil.isImage(imageToAdd.getPath())) {
            throw new SilverpeasRuntimeException("The picture to add is not an image file");
        }
        try (PdfReader reader = null;){
            reader = new PdfReader(pdfSource);
            int pdfNbPages = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, pdfDestination);
            Image image = Image.getInstance((String)imageToAdd.getPath());
            float imageWidth = image.getWidth();
            float imageHeigth = image.getHeight();
            for (int i = 1; i <= pdfNbPages; ++i) {
                Rectangle rectangle = reader.getPageSize(i);
                float scale = Math.min(100.0f, rectangle.getWidth() / imageWidth * 100.0f);
                image.scalePercent(Math.min(scale, rectangle.getHeight() / imageHeigth * 100.0f));
                image.setAbsolutePosition(PdfUtil.computeImageCenterPosition(rectangle.getWidth(), image.getScaledWidth()), PdfUtil.computeImageCenterPosition(rectangle.getHeight(), image.getScaledHeight()));
                PdfContentByte imageContainer = isBackground ? stamper.getUnderContent(i) : stamper.getOverContent(i);
                imageContainer.addImage(image);
            }
            stamper.close();
        }
    }

    private static float computeImageCenterPosition(float documentSize, float imageSize) {
        float differenceSize = documentSize - imageSize;
        return differenceSize / 2.0f;
    }
}

