/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.SilverpeasList;

public class Pagination<T> {
    private final PaginationPage paginationPage;
    private Function<PaginationPage, SilverpeasList<T>> paginatedDataSource;
    private UnaryOperator<SilverpeasList<T>> filter;
    private int minPerPage = 0;
    private int factor = 5;
    private int nbMaxDataSourceCalls = 0;
    private boolean nbMaxDataSourceCallLimitReached = false;

    public Pagination(PaginationPage paginationPage) {
        this.paginationPage = paginationPage;
    }

    public Pagination<T> factor(int factor) {
        this.factor = factor;
        return this;
    }

    public Pagination<T> withMinPerPage(int minPerPage) {
        this.minPerPage = minPerPage;
        return this;
    }

    public Pagination<T> limitDataSourceCallsTo(int nbMaxDataSourceCalls) {
        this.nbMaxDataSourceCalls = nbMaxDataSourceCalls;
        return this;
    }

    public Pagination<T> paginatedDataSource(Function<PaginationPage, SilverpeasList<T>> paginatedDataSource) {
        this.paginatedDataSource = paginatedDataSource;
        return this;
    }

    public Pagination<T> filter(UnaryOperator<SilverpeasList<T>> filter) {
        this.filter = filter;
        return this;
    }

    public SilverpeasList<T> execute() {
        if (this.paginatedDataSource == null) {
            throw new IllegalArgumentException("paginatedDataSource must be defined");
        }
        if (this.factor <= 0) {
            throw new IllegalArgumentException("factor must be positive");
        }
        if (this.minPerPage < 0) {
            throw new IllegalArgumentException("minPerPage must be positive or equal to zero");
        }
        PaginationPage currentPagination = new PaginationPage(this.paginationPage.getPageNumber(), Math.max(this.paginationPage.getPageSize() * this.factor, this.minPerPage));
        if (!this.paginationPage.asCriterion().isOriginalSizeNeeded()) {
            currentPagination.originalSizeIsNotRequired();
        }
        SilverpeasList<T> result = null;
        boolean running = true;
        int nbDataSourceCalls = 0;
        while (running) {
            SilverpeasList currentResult = this.paginatedDataSource.apply(currentPagination);
            ++nbDataSourceCalls;
            if (currentResult.size() < this.paginationPage.getPageSize()) {
                running = false;
            }
            currentResult = (SilverpeasList)this.filter.apply(currentResult);
            result = this.completeResult(currentResult, result);
            currentPagination = new PaginationPage(currentPagination.getPageNumber() + 1, currentPagination.getPageSize());
            if (!this.paginationPage.asCriterion().isOriginalSizeNeeded()) {
                currentPagination.originalSizeIsNotRequired();
            }
            if (result.size() >= this.paginationPage.getPageSize()) {
                running = false;
                continue;
            }
            if (nbDataSourceCalls != this.nbMaxDataSourceCalls) continue;
            running = false;
            this.nbMaxDataSourceCallLimitReached = true;
        }
        return result;
    }

    public boolean isNbMaxDataSourceCallLimitReached() {
        return this.nbMaxDataSourceCallLimitReached;
    }

    private SilverpeasList<T> completeResult(SilverpeasList<T> currentResult, SilverpeasList<T> previousResult) {
        SilverpeasList<T> result = previousResult;
        if (result == null) {
            result = this.paginationPage.getPageSize() > 0 && currentResult.size() > this.paginationPage.getPageSize() ? (SilverpeasList)currentResult.stream().limit(this.paginationPage.getPageSize()).collect(SilverpeasList.collector(currentResult)) : currentResult;
        } else {
            for (int i = 0; i < currentResult.size() && result.size() < this.paginationPage.getPageSize(); ++i) {
                result.add(currentResult.get(i));
            }
        }
        return result;
    }
}

