/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.constant.SubscriptionMethod;
import org.silverpeas.core.subscription.service.AbstractSubscription;
import org.silverpeas.core.subscription.service.AbstractSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.GroupSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.subscription.util.SubscriptionList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class SubscriptionDao {
    private static final String SUBSCRIBE_TABLE = "subscribe";
    private static final String RESOURCE_ID = "resourceId";
    private static final String RESOURCE_ID_CLAUSE = "resourceId = ?";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCE_TYPE_CLAUSE = "resourceType = ?";
    private static final String INSTANCE_ID = "instanceId";
    private static final String INSTANCE_ID_CLAUSE = "instanceId = ?";
    private static final String SUBSCRIBER_ID = "subscriberId";
    private static final String SUBSCRIBER_ID_CLAUSE = "subscriberId = ?";
    private static final String SUBSCRIBER_TYPE = "subscriberType";
    private static final String SUBSCRIBER_TYPE_CLAUSE = "subscriberType = ?";
    private static final String SUBSCRIPTION_METHOD = "subscriptionMethod";
    private static final String SUBSCRIPTION_METHOD_CLAUSE = "subscriptionMethod = ?";
    private static final String SUBSCRIBE_COLUMNS = "subscriberId, subscriberType, subscriptionMethod, resourceId, resourceType, space, instanceId, creatorId, creationDate";
    private static final String ADD_SUBSCRIPTION = "INSERT INTO subscribe (subscriberId, subscriberType, subscriptionMethod, resourceId, resourceType, space, instanceId, creatorId, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? )";
    private static final String REMOVE_SUBSCRIPTIONS_BY_SUBSCRIBER = "DELETE FROM subscribe WHERE subscriberId = ? AND subscriberType = ?";
    private static final String REMOVE_SUBSCRIPTIONS_BY_INSTANCEID = "DELETE FROM subscribe WHERE instanceId = ?";
    private static final String SELECT = "SELECT ";
    private static final String SELECT_SUBSCRIPTIONS_BY_SUBSCRIBER = "SELECT subscriberId, subscriberType, subscriptionMethod, resourceId, resourceType, space, instanceId, creatorId, creationDate FROM subscribe WHERE subscriberId = ? AND subscriberType = ?";
    private static final String SELECT_SUBSCRIPTIONS_BY_SUBSCRIBER_AND_COMPONENT = "SELECT subscriberId, subscriberType, subscriptionMethod, resourceId, resourceType, space, instanceId, creatorId, creationDate FROM subscribe WHERE subscriberId = ? AND subscriberType = ? AND instanceId = ?";
    @Inject
    private SubscriptionFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Connection con, Subscription subscription) throws SQLException, AssertionError {
        if (!(subscription.getSubscriber().getType().isValid() && subscription.getSubscriptionMethod().isValid() && subscription.getResource().getType().isValid())) {
            throw new AssertionError((Object)"Subscriber type, subscription method or resource type is unknown ...");
        }
        PreparedStatement prepStmt = null;
        try {
            String space = subscription.getResource().getPK().getSpace();
            prepStmt = con.prepareStatement(ADD_SUBSCRIPTION);
            prepStmt.setString(1, subscription.getSubscriber().getId());
            prepStmt.setString(2, subscription.getSubscriber().getType().getName());
            prepStmt.setString(3, subscription.getSubscriptionMethod().getName());
            prepStmt.setString(4, subscription.getResource().getId());
            prepStmt.setString(5, subscription.getResource().getType().getName());
            prepStmt.setString(6, StringUtil.isDefined((String)space) ? space : "-");
            prepStmt.setString(7, subscription.getResource().getInstanceId());
            prepStmt.setString(8, subscription.getCreatorId());
            prepStmt.setTimestamp(9, new Timestamp(subscription.getCreationDate() == null ? DateUtil.getNow().getTime() : subscription.getCreationDate().getTime()));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public void remove(Connection con, Subscription subscription) throws SQLException {
        SubscriptionSubscriber subscriber = subscription.getSubscriber();
        SubscriptionResource resource = subscription.getResource();
        JdbcSqlQuery.deleteFrom((String)SUBSCRIBE_TABLE).where(SUBSCRIBER_ID_CLAUSE, new Object[]{subscriber.getId()}).and(SUBSCRIBER_TYPE_CLAUSE, new Object[]{subscriber.getType().getName()}).and(SUBSCRIPTION_METHOD_CLAUSE, new Object[]{subscription.getSubscriptionMethod().getName()}).and(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()}).and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()}).executeWith(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBySubscriber(Connection con, SubscriptionSubscriber subscriber) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(REMOVE_SUBSCRIPTIONS_BY_SUBSCRIBER);
            prepStmt.setString(1, subscriber.getId());
            prepStmt.setString(2, subscriber.getType().getName());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public void removeByResource(Connection con, SubscriptionResource resource) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)SUBSCRIBE_TABLE).where(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()}).and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()}).executeWith(con);
    }

    public void removeByInstanceId(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(REMOVE_SUBSCRIPTIONS_BY_INSTANCEID);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    public boolean existsSubscription(Connection con, Subscription subscription) throws SQLException {
        SubscriptionSubscriber subscriber = subscription.getSubscriber();
        SubscriptionResource resource = subscription.getResource();
        return (Boolean)JdbcSqlQuery.countAll().from(new String[]{SUBSCRIBE_TABLE}).where(SUBSCRIBER_ID_CLAUSE, new Object[]{subscriber.getId()}).and(SUBSCRIBER_TYPE_CLAUSE, new Object[]{subscriber.getType().getName()}).and(SUBSCRIPTION_METHOD_CLAUSE, new Object[]{subscription.getSubscriptionMethod().getName()}).and(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()}).and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()}).executeUniqueWith(con, r -> r.getLong(1) > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionList getSubscriptionsBySubscriber(Connection con, SubscriptionSubscriber subscriber) throws SQLException {
        SubscriptionList subscriptionList;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(SELECT_SUBSCRIPTIONS_BY_SUBSCRIBER);
            prepStmt.setString(1, subscriber.getId());
            prepStmt.setString(2, subscriber.getType().getName());
            rs = prepStmt.executeQuery();
            subscriptionList = this.toList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return subscriptionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionList getSubscriptionsBySubscriberAndComponent(Connection con, SubscriptionSubscriber subscriber, String instanceId) throws SQLException {
        SubscriptionList subscriptionList;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(SELECT_SUBSCRIPTIONS_BY_SUBSCRIBER_AND_COMPONENT);
            prepStmt.setString(1, subscriber.getId());
            prepStmt.setString(2, subscriber.getType().getName());
            prepStmt.setString(3, instanceId);
            rs = prepStmt.executeQuery();
            subscriptionList = this.toList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return subscriptionList;
    }

    public SubscriptionList getSubscriptionsByResource(Connection con, SubscriptionResource resource, SubscriptionMethod method) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)SUBSCRIBE_COLUMNS).from(new String[]{SUBSCRIBE_TABLE}).where(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()});
        if (StringUtil.isDefined((String)resource.getInstanceId())) {
            query = query.and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()});
        }
        if (method != null && !SubscriptionMethod.UNKNOWN.equals((Object)method)) {
            query = query.and(SUBSCRIPTION_METHOD_CLAUSE, new Object[]{method.getName()});
        }
        return new SubscriptionList((Collection<? extends Subscription>)query.executeWith(con, this::createSubscriptionInstance));
    }

    public SubscriptionList getSubscriptionsBySubscriberAndResource(Connection con, SubscriptionSubscriber subscriber, SubscriptionResource resource) throws SQLException {
        return new SubscriptionList((Collection<? extends Subscription>)JdbcSqlQuery.select((String)SUBSCRIBE_COLUMNS).from(new String[]{SUBSCRIBE_TABLE}).where(SUBSCRIBER_ID_CLAUSE, new Object[]{subscriber.getId()}).and(SUBSCRIBER_TYPE_CLAUSE, new Object[]{subscriber.getType().getName()}).and(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()}).and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()}).executeWith(con, this::createSubscriptionInstance));
    }

    public SubscriptionSubscriberList getSubscribers(Connection con, SubscriptionResource resource, SubscriptionMethod method) throws SQLException {
        return this.getSubscribers(con, Collections.singletonList(resource), method);
    }

    public SubscriptionSubscriberList getSubscribers(Connection con, Collection<? extends SubscriptionResource> resources, SubscriptionMethod method) throws SQLException {
        HashSet<SubscriptionSubscriber> result = new HashSet<SubscriptionSubscriber>();
        for (SubscriptionResource subscriptionResource : resources) {
            this.findSubscribers(con, subscriptionResource, result, method);
        }
        return new SubscriptionSubscriberList((Collection<? extends SubscriptionSubscriber>)result);
    }

    private void findSubscribers(Connection con, SubscriptionResource resource, Collection<SubscriptionSubscriber> result, SubscriptionMethod method) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"subscriberId, subscriberType").from(new String[]{SUBSCRIBE_TABLE}).where(RESOURCE_ID_CLAUSE, new Object[]{resource.getId()}).and(RESOURCE_TYPE_CLAUSE, new Object[]{resource.getType().getName()}).and(INSTANCE_ID_CLAUSE, new Object[]{resource.getInstanceId()});
        if (method != null && !SubscriptionMethod.UNKNOWN.equals((Object)method)) {
            query = query.and(SUBSCRIPTION_METHOD_CLAUSE, new Object[]{method.getName()});
        }
        query.executeWith(con, r -> {
            SubscriptionSubscriber subscriber = this.createSubscriberInstance(r.getString(1), SubscriberType.from(r.getString(2)));
            if (subscriber != null) {
                result.add(subscriber);
            }
            return null;
        });
    }

    private SubscriptionList toList(ResultSet rs) throws SQLException {
        SubscriptionList list = new SubscriptionList();
        while (rs.next()) {
            Subscription subscription = this.createSubscriptionInstance(rs);
            if (subscription == null) continue;
            list.add(subscription);
        }
        return list;
    }

    private Subscription createSubscriptionInstance(ResultSet rs) throws SQLException {
        SubscriberType subscriberType = SubscriberType.from(rs.getString(SUBSCRIBER_TYPE));
        SubscriptionSubscriber subscriber = this.createSubscriberInstance(rs.getString(SUBSCRIBER_ID), subscriberType);
        SubscriptionMethod subscriptionMethod = SubscriptionMethod.from(rs.getString(SUBSCRIPTION_METHOD));
        SubscriptionResourceType resourceType = SubscriptionResourceType.from(rs.getString(RESOURCE_TYPE));
        SubscriptionResource resource = this.factory.createSubscriptionResourceInstance(resourceType, rs.getString(RESOURCE_ID), rs.getString("space"), rs.getString(INSTANCE_ID));
        if (!subscriptionMethod.isValid() || subscriber == null || resource == null) {
            SilverLogger.getLogger((Object)this).warn("The subscription method is'nt valid or either the subscriber or the resource is'nt defined", new Object[0]);
            return null;
        }
        if (CommonSubscriptionResourceConstants.UNKNOWN.equals(resourceType)) {
            throw new AssertionError((Object)"There is no reason to be here !");
        }
        String creatorId = rs.getString("creatorId");
        Timestamp creationDate = rs.getTimestamp("creationDate");
        if (((Date)creationDate).getTime() <= 0L) {
            creationDate = null;
        }
        AbstractSubscription<SubscriptionResource> subscription = this.factory.createSubscriptionInstance(subscriber, resource, creatorId);
        subscription.setSubscriptionMethod(subscriptionMethod);
        subscription.setCreationDate(creationDate);
        return subscription;
    }

    private SubscriptionSubscriber createSubscriberInstance(String subscriberId, SubscriberType subscriberType) {
        AbstractSubscriptionSubscriber subscriber;
        switch (subscriberType) {
            case USER: {
                subscriber = new UserSubscriptionSubscriber(subscriberId);
                break;
            }
            case GROUP: {
                subscriber = new GroupSubscriptionSubscriber(subscriberId);
                break;
            }
            default: {
                subscriber = null;
            }
        }
        return subscriber;
    }
}

