/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.relationship;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.SocialInformationRelationShip;

@Repository
public class RelationShipDao {
    private static final String INSERT_RELATIONSHIP = "INSERT INTO sb_sn_RelationShip (id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterid) VALUES (?, ?, ?, ?, ?,?)";
    private static final String DELETE_RELATIONSHIP = "DELETE FROM sb_sn_RelationShip WHERE user1Id = ? and user2Id= ? ";
    private static final String SELECT_RELATIONSHIP = "SELECT id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterId FROM sb_sn_RelationShip  WHERE user1Id = ? and user2Id= ?";
    private static final String SELECT_ALL_MY_RELATIONSHIP = "SELECT id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterId FROM sb_sn_RelationShip  WHERE user1Id = ?";
    private static final String SELECT_RELATIONSHIP_BYID = "SELECT id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterId FROM sb_sn_RelationShip  WHERE id = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createRelationShip(Connection connection, RelationShip relationShip) throws SQLException {
        int id = DBUtil.getNextId((String)"sb_sn_RelationShip", (String)"id");
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(INSERT_RELATIONSHIP);
            pstmt.setInt(1, id);
            pstmt.setInt(2, relationShip.getUser1Id());
            pstmt.setInt(3, relationShip.getUser2Id());
            pstmt.setInt(4, relationShip.getTypeRelationShipId());
            pstmt.setTimestamp(5, new Timestamp(relationShip.getAcceptanceDate().getTime()));
            pstmt.setInt(6, relationShip.getInviterId());
            pstmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)pstmt);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRelationShip(Connection connection, int user1Id, int user2Id) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(DELETE_RELATIONSHIP);
            pstmt.setInt(1, user1Id);
            pstmt.setInt(2, user2Id);
            pstmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationShip getRelationShip(Connection connection, int user1Id, int user2Id) throws SQLException {
        RelationShip relationShip = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_RELATIONSHIP);
            pstmt.setInt(1, user1Id);
            pstmt.setInt(2, user2Id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                relationShip = this.resultSet2RelationShip(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return relationShip;
    }

    public boolean isInRelationShip(Connection connection, int user1Id, int user2Id) throws SQLException {
        return this.getRelationShip(connection, user1Id, user2Id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RelationShip> getAllMyRelationShips(Connection connection, int myId) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<RelationShip> listMyRelation = new ArrayList<RelationShip>();
        try {
            pstmt = connection.prepareStatement(SELECT_ALL_MY_RELATIONSHIP);
            pstmt.setInt(1, myId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RelationShip relationShip = this.resultSet2RelationShip(rs);
                listMyRelation.add(relationShip);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return listMyRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllMyRelationShips(Connection con, String userId, Date begin, Date end) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<SocialInformation> listMyRelation = new ArrayList<SocialInformation>();
        String query = "SELECT id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterId FROM sb_sn_RelationShip  WHERE user1Id = ? and acceptanceDate >= ? and acceptanceDate <= ? order by acceptanceDate desc, id desc ";
        try {
            pstmt = con.prepareStatement(query);
            pstmt.setInt(1, Integer.parseInt(userId));
            pstmt.setTimestamp(2, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(3, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RelationShip relationShip = this.resultSet2RelationShip(rs);
                listMyRelation.add(new SocialInformationRelationShip(relationShip));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return listMyRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SocialInformation> getAllRelationShipsOfContacts(Connection con, List<String> myContactsIds, Date begin, Date end) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<SocialInformation> listMyRelation = new ArrayList<SocialInformation>();
        String query = "SELECT id, user1Id, user2Id, typeRelationShipId, acceptanceDate,inviterId FROM sb_sn_RelationShip WHERE user1Id in(" + RelationShipDao.toSqlString(myContactsIds) + ") and inviterid=user1Id and acceptanceDate >= ? and acceptanceDate <= ? order by acceptanceDate desc ";
        try {
            pstmt = con.prepareStatement(query);
            pstmt.setTimestamp(1, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RelationShip relationShip = this.resultSet2RelationShip(rs);
                listMyRelation.add(new SocialInformationRelationShip(relationShip));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return listMyRelation;
    }

    private RelationShip resultSet2RelationShip(ResultSet rs) throws SQLException {
        RelationShip relationShip = new RelationShip();
        relationShip.setId(rs.getInt(1));
        relationShip.setUser1Id(rs.getInt(2));
        relationShip.setUser2Id(rs.getInt(3));
        relationShip.setTypeRelationShipId(rs.getInt(4));
        relationShip.setAcceptanceDate(new Date(rs.getTimestamp(5).getTime()));
        relationShip.setInviterId(rs.getInt(6));
        return relationShip;
    }

    private static String toSqlString(List<String> list) {
        StringBuilder result = new StringBuilder();
        if (list == null || list.isEmpty()) {
            return "''";
        }
        int i = 0;
        for (String var : list) {
            if (i != 0) {
                result.append(",");
            }
            result.append("'").append(var).append("'");
            ++i;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getMyContactsIds(Connection connection, int myId) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<String> myContactsIds = new ArrayList<String>();
        try {
            String query = "SELECT user2Id FROM sb_sn_RelationShip, st_user WHERE user1Id = ? and user2Id = st_user.id and st_user.state not in ('DELETED', 'REMOVED')";
            pstmt = connection.prepareStatement(query);
            pstmt.setInt(1, myId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                myContactsIds.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return myContactsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllCommonContactsIds(Connection connection, int user1Id, int user2Id) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<String> myContactsIds = new ArrayList<String>();
        try {
            String query = "SELECT user2Id FROM sb_sn_RelationShip, st_user WHERE user1Id = ? and user2id in (SELECT user2Id FROM sb_sn_RelationShip WHERE user1Id = ?) and user2Id = st_user.id and st_user.state not in ('DELETED', 'REMOVED')";
            pstmt = connection.prepareStatement(query);
            pstmt.setInt(1, user1Id);
            pstmt.setInt(2, user2Id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                myContactsIds.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return myContactsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationShip getRelationShip(Connection connection, int relationShipId) throws SQLException {
        RelationShip relationShip = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_RELATIONSHIP_BYID);
            pstmt.setInt(1, relationShipId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                relationShip = this.resultSet2RelationShip(rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return relationShip;
    }
}

