/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import javax.inject.Singleton;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.ComponentInstancePublicationAccessControlExtension;
import org.silverpeas.kernel.annotation.Base;

@Base
@Singleton
public class DefaultInstancePublicationAccessControlExtension
implements ComponentInstancePublicationAccessControlExtension {
    @Override
    public boolean canPublicationBePersistedOrDeletedBy(PublicationDetail publication, String instanceId, String userId, SilverpeasRole userRole, AccessControlContext context) {
        boolean authorized = userRole.isGreaterThan(SilverpeasRole.WRITER) ? publication == null || !publication.isDraft() || publication.isPublicationEditor(userId) || this.isCoWritingEnabled(instanceId, context) && this.isDraftVisibleWithCoWriting() : (SilverpeasRole.WRITER == userRole ? (publication != null ? (publication.isPublicationEditor(userId) ? true : (publication.isDraft() ? this.isCoWritingEnabled(instanceId, context) && this.isDraftVisibleWithCoWriting() : this.isCoWritingEnabled(instanceId, context))) : this.isCoWritingEnabled(instanceId, context)) : false);
        return authorized;
    }

    private boolean isCoWritingEnabled(String instanceId, AccessControlContext context) {
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        return componentDataManager.isCoWritingEnabled(instanceId);
    }

    protected boolean isDraftVisibleWithCoWriting() {
        return false;
    }
}

