/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import org.silverpeas.core.security.authentication.AuthenticationConnection;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPwdChangeNotAvailException;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AuthenticationProtocol {
    protected boolean enabled = true;
    public static final String PASSWORD_IS_ABOUT_TO_EXPIRE = "Svp_Pwd_About_To_Expire";
    public static final String PASSWORD_CHANGE_ALLOWED = "Svp_Password_Change_Allowed";
    private String authServerName;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getServerName() {
        return this.authServerName;
    }

    public void init(String authenticationServerName, SettingBundle settings) {
        this.authServerName = authenticationServerName;
        this.enabled = settings.getBoolean(this.authServerName + ".enabled", true);
        this.loadProperties(settings);
    }

    public void authenticate(final AuthenticationCredential credential) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("authenticate"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                AuthenticationProtocol.this.doAuthentication(connection, credential);
            }
        });
    }

    public void changePassword(final AuthenticationCredential credential, final String newPassword) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("changePassword"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                AuthenticationProtocol.this.doChangePassword(connection, credential, newPassword);
            }
        });
    }

    public void resetPassword(final String login, final boolean loginIgnoreCase, final String newPassword) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("resetPassword"){

            @Override
            public <T> void perform(AuthenticationConnection<T> connection) throws AuthenticationException {
                AuthenticationProtocol.this.doResetPassword(connection, login, loginIgnoreCase, newPassword);
            }
        });
    }

    protected abstract void loadProperties(SettingBundle var1);

    protected abstract <T> AuthenticationConnection<T> openConnection() throws AuthenticationException;

    protected abstract <T> void closeConnection(AuthenticationConnection<T> var1) throws AuthenticationException;

    protected abstract <T> void doAuthentication(AuthenticationConnection<T> var1, AuthenticationCredential var2) throws AuthenticationException;

    protected <T> void doChangePassword(AuthenticationConnection<T> connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        throw new AuthenticationPwdChangeNotAvailException("The password modification isn't available", new String[0]);
    }

    protected <T> void doResetPassword(AuthenticationConnection<T> connection, String login, boolean loginIgnoreCase, String newPassword) throws AuthenticationException {
        throw new AuthenticationPwdChangeNotAvailException("The password reset isn't available", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSecurityOperation(SecurityOperation op) throws AuthenticationException {
        AuthenticationConnection connection = null;
        try {
            connection = this.openConnection();
            op.perform(connection);
        }
        finally {
            try {
                if (connection != null) {
                    this.closeConnection(connection);
                }
            }
            catch (AuthenticationException closeEx) {
                SilverLogger.getLogger((Object)this).error((Throwable)closeEx);
            }
        }
    }

    private static abstract class SecurityOperation {
        public static final String AUTHENTICATION = "authenticate";
        public static final String PASSWORD_CHANGE = "changePassword";
        public static final String PASSWORD_RESET = "resetPassword";
        private final String name;

        public SecurityOperation(String operationName) {
            this.name = operationName;
        }

        public String getName() {
            return this.name;
        }

        public abstract <T> void perform(AuthenticationConnection<T> var1) throws AuthenticationException;
    }
}

