/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.xml;

import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationTag;
import org.silverpeas.core.notification.user.server.xml.AnswerAllowedContentHandler;
import org.silverpeas.core.notification.user.server.xml.SenderIdContentHandler;
import org.silverpeas.core.notification.user.server.xml.SenderNameContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SenderContentHandler
extends DefaultHandler {
    private final NotificationData data;
    private final ContentHandler parent;
    private final XMLReader parser;

    public SenderContentHandler(NotificationData data, ContentHandler parent, XMLReader parser) {
        this.data = data;
        this.parent = parent;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DefaultHandler child;
        NotificationTag tag = NotificationTag.valueOf(qName);
        switch (tag) {
            case NAME: {
                child = new SenderNameContentHandler(this.data, this, this.parser);
                break;
            }
            case ID: {
                child = new SenderIdContentHandler(this.data, this, this.parser);
                break;
            }
            case ANSWERALLOWED: {
                child = new AnswerAllowedContentHandler(this.data, this, this.parser);
                break;
            }
            default: {
                child = null;
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
            child.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        if (tag == NotificationTag.SENDER) {
            this.parser.setContentHandler(this.parent);
        }
    }
}

