/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.silvermail;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.core.notification.user.server.channel.silvermail.JPQLQueryBuilder;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessageBean;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteria;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.util.SilverpeasList;

public class SILVERMAILMessageBeanRepository
extends BasicJpaEntityRepository<SILVERMAILMessageBean> {
    private static final String USER_ID = "userId";
    private static final String FOLDER_ID = "folderId";

    public long countByCriteria(SilvermailCriteria criteria) {
        NamedParameters params = this.newNamedParameters();
        JPQLQueryBuilder queryBuilder = new JPQLQueryBuilder(params);
        criteria.processWith(queryBuilder);
        return this.countByCriteria(queryBuilder.result());
    }

    public SilverpeasList<SILVERMAILMessageBean> findByCriteria(SilvermailCriteria criteria) {
        NamedParameters params = this.newNamedParameters();
        JPQLQueryBuilder queryBuilder = new JPQLQueryBuilder(params);
        criteria.processWith(queryBuilder);
        return this.findByCriteria(queryBuilder.result());
    }

    public long markAsReadAllMessagesByUserIdAndFolderId(String userId, String folderId) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add(FOLDER_ID, (Object)Long.parseLong(folderId));
        return this.updateFromNamedQuery("markAllMessagesAsReadByUserIdAndFolderId", parameters);
    }

    public long markAsReadMessagesByUserIdAndByIds(String userId, Collection<String> ids) {
        if (ids.isEmpty()) {
            return 0L;
        }
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add("ids", (Object)this.getIdentifierConverter().convertToEntityIdentifiers(ids));
        return this.updateFromNamedQuery("markAllMessagesAsReadByUserIdAndIds", parameters);
    }

    public List<String> getLongTextIdsOfAllMessagesByUserIdAndFolderId(String userId, String folderId) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add(FOLDER_ID, (Object)Long.parseLong(folderId));
        return this.listFromNamedQuery("getLongTextIdsOfAllMessagesByUserIdAndFolderId", parameters, String.class);
    }

    public long deleteAllMessagesByUserIdAndFolderId(String userId, String folderId) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add(FOLDER_ID, (Object)Long.parseLong(folderId));
        return this.updateFromNamedQuery("deleteAllMessagesByUserIdAndFolderId", parameters);
    }

    public List<String> getLongTextIdsOfMessagesByUserIdAndByIds(String userId, Collection<String> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add("ids", (Object)this.getIdentifierConverter().convertToEntityIdentifiers(ids));
        return this.listFromNamedQuery("getLongTextIdsOfAllMessagesByUserIdAndIds", parameters, String.class);
    }

    public long deleteMessagesByUserIdAndByIds(String userId, Collection<String> ids) {
        if (ids.isEmpty()) {
            return 0L;
        }
        NamedParameters parameters = this.newNamedParameters();
        parameters.add(USER_ID, (Object)Long.parseLong(userId)).add("ids", (Object)this.getIdentifierConverter().convertToEntityIdentifiers(ids));
        return this.updateFromNamedQuery("deleteAllMessagesByUserIdAndIds", parameters);
    }
}

