/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.delayed.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.AttachmentLink;
import org.silverpeas.core.notification.user.client.NotificationParameterNames;
import org.silverpeas.core.notification.user.client.NotificationTemplateKey;
import org.silverpeas.core.notification.user.client.NotificationURLProvider;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.delayed.DelayedNotificationProvider;
import org.silverpeas.core.notification.user.delayed.constant.DelayedNotificationFrequency;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationData;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationUserSetting;
import org.silverpeas.core.notification.user.delayed.synthese.DelayedNotificationSyntheseData;
import org.silverpeas.core.notification.user.delayed.synthese.SyntheseResource;
import org.silverpeas.core.notification.user.delayed.synthese.SyntheseResourceNotification;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServer;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.comparator.AbstractComplexComparator;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class DelayedNotificationDelegate
implements NotificationURLProvider {
    private static final String LOCATION_SEPARATOR = " > ";
    private static final int MAX_USER_DETAIL_ITEMS = 100;
    private final Map<Integer, UserDetail> userDetailCache = new LinkedHashMap<Integer, UserDetail>(100);
    private SilverpeasTemplate template = null;
    private Comparator<NotificationResourceData> resourceComparator;
    private Comparator<DelayedNotificationData> delayedNotificationComparator;

    protected DelayedNotificationDelegate() {
    }

    public static void executeUserDeleting(int userId) throws NotificationServerException {
        DelayedNotificationDelegate.executeForceDelayedNotificationsSending(userId, DelayedNotificationProvider.getDelayedNotification().getWiredChannels());
        for (NotifChannel channel : DelayedNotificationProvider.getDelayedNotification().getWiredChannels()) {
            DelayedNotificationUserSetting settings = DelayedNotificationProvider.getDelayedNotification().getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
            if (settings == null) continue;
            DelayedNotificationProvider.getDelayedNotification().deleteDelayedNotificationUserSetting(settings);
        }
    }

    public static DelayedNotificationUserSetting executeUserSettingsUpdating(int userId, NotifChannel channel, DelayedNotificationFrequency frequency) throws NotificationServerException {
        DelayedNotificationUserSetting result = null;
        DelayedNotificationUserSetting oldSettings = DelayedNotificationProvider.getDelayedNotification().getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
        if (frequency != null) {
            result = DelayedNotificationProvider.getDelayedNotification().saveDelayedNotificationUserSetting(userId, channel, frequency);
        } else if (oldSettings != null) {
            DelayedNotificationProvider.getDelayedNotification().deleteDelayedNotificationUserSetting(oldSettings);
        }
        if (oldSettings == null && frequency != null || oldSettings != null && !oldSettings.getFrequency().equals((Object)frequency)) {
            DelayedNotificationDelegate.executeForceDelayedNotificationsSending(userId, Collections.singleton(channel));
        }
        return result;
    }

    public static void executeNewNotification(DelayedNotificationData delayedNotificationData) throws NotificationServerException {
        new DelayedNotificationDelegate().performNewNotificationSending(delayedNotificationData);
    }

    protected void performNewNotificationSending(DelayedNotificationData delayedNotificationData) throws NotificationServerException {
        if (!this.isThatToBeDelayed(delayedNotificationData)) {
            this.sendNotification(delayedNotificationData.getNotificationData());
        } else {
            DelayedNotificationProvider.getDelayedNotification().saveDelayedNotification(delayedNotificationData);
        }
    }

    private boolean isThatToBeDelayed(DelayedNotificationData delayedNotificationData) {
        if (delayedNotificationData.isSendImmediately()) {
            return false;
        }
        if (delayedNotificationData.getAction() == null) {
            return false;
        }
        if (0 != delayedNotificationData.getNotificationParameters().getMessagePriority()) {
            return false;
        }
        if (DelayedNotificationFrequency.NONE.equals((Object)DelayedNotificationProvider.getDelayedNotification().getUserFrequency(delayedNotificationData.getUserId(), delayedNotificationData.getChannel()))) {
            return false;
        }
        return delayedNotificationData.isValid();
    }

    public static void executeDelayedNotificationsSending(Date date) throws NotificationServerException {
        new DelayedNotificationDelegate().performDelayedNotificationsSending(date, DelayedNotificationProvider.getDelayedNotification().getWiredChannels());
    }

    public static void executeForceDelayedNotificationsSending(int userId, Set<NotifChannel> channels) throws NotificationServerException {
        DelayedNotificationDelegate.executeForceDelayedNotificationsSending(Collections.singletonList(userId), channels);
    }

    public static void executeForceDelayedNotificationsSending(List<Integer> userIds, Set<NotifChannel> channels) throws NotificationServerException {
        new DelayedNotificationDelegate().forceDelayedNotificationsSending(userIds, channels);
    }

    protected void forceDelayedNotificationsSending() throws NotificationServerException {
        List<Integer> usersToBeNotified = DelayedNotificationProvider.getDelayedNotification().findAllUsersToBeNotified(DelayedNotificationProvider.getDelayedNotification().getWiredChannels());
        this.forceDelayedNotificationsSending(usersToBeNotified, DelayedNotificationProvider.getDelayedNotification().getWiredChannels());
    }

    void forceDelayedNotificationsSending(List<Integer> userIds, Set<NotifChannel> channels) throws NotificationServerException {
        this.performUsersDelayedNotifications(userIds, channels);
    }

    void performDelayedNotificationsSending(Date date, Set<NotifChannel> channels) throws NotificationServerException {
        List<Integer> usersToBeNotified = DelayedNotificationProvider.getDelayedNotification().findUsersToBeNotified(date, channels, DelayedNotificationProvider.getDelayedNotification().getDefaultDelayedNotificationFrequency());
        this.performUsersDelayedNotifications(usersToBeNotified, channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUsersDelayedNotifications(List<Integer> usersToBeNotified, Set<NotifChannel> channels) throws NotificationServerException {
        if (CollectionUtil.isEmpty(usersToBeNotified)) {
            return;
        }
        ArrayList<Long> delayedNotificationIdsToDelete = new ArrayList<Long>();
        try {
            for (Integer userIdToNotify : usersToBeNotified) {
                Map<NotifChannel, List<DelayedNotificationData>> delayedNotifications = DelayedNotificationProvider.getDelayedNotification().findDelayedNotificationByUserIdGroupByChannel(userIdToNotify, channels);
                for (Map.Entry<NotifChannel, List<DelayedNotificationData>> mapEntry : delayedNotifications.entrySet()) {
                    delayedNotificationIdsToDelete.addAll(this.performUserDelayedNotificationsOnChannel(mapEntry.getKey(), mapEntry.getValue()));
                }
            }
        }
        finally {
            DelayedNotificationProvider.getDelayedNotification().deleteDelayedNotifications(delayedNotificationIdsToDelete);
        }
    }

    private Collection<Long> performUserDelayedNotificationsOnChannel(NotifChannel channel, List<DelayedNotificationData> delayedNotifications) throws NotificationServerException {
        DelayedNotificationSyntheseData synthesis = this.buildSynthesis(delayedNotifications);
        this.sendNotification(this.createNotificationData(channel, synthesis));
        return synthesis.getDelayedNotificationIdProceeded();
    }

    private DelayedNotificationSyntheseData buildSynthesis(List<DelayedNotificationData> delayedNotifications) {
        DelayedNotificationSyntheseData synthesis = this.initializeSynthese(delayedNotifications);
        HashMap resourcesAndNotifications = new HashMap();
        for (DelayedNotificationData delayedNotificationData : delayedNotifications) {
            MapUtil.putAddList(resourcesAndNotifications, delayedNotificationData.getResource(), delayedNotificationData);
        }
        ArrayList orderedResources = new ArrayList(resourcesAndNotifications.keySet());
        orderedResources.sort(this.getResourceComparator());
        for (NotificationResourceData resource : orderedResources) {
            this.prepareSynthesisResourceAndNotifications(synthesis, resource, (List)resourcesAndNotifications.get(resource));
        }
        synthesis.setMessage(this.buildMessage(synthesis));
        return synthesis;
    }

    private void prepareSynthesisResourceAndNotifications(DelayedNotificationSyntheseData synthesis, NotificationResourceData resource, List<DelayedNotificationData> notifications) {
        String language = synthesis.getLanguage();
        resource.setCurrentLanguage(language);
        notifications.sort(this.getDelayedNotificationComparator());
        SyntheseResource syntheseResource = new SyntheseResource();
        synthesis.addResource(syntheseResource);
        synthesis.addNbNotifications(notifications.size());
        syntheseResource.setName(resource.getResourceName());
        syntheseResource.setDescription(resource.getResourceDescription());
        syntheseResource.setLocation(resource.getResourceLocation().replace("@#@#@", LOCATION_SEPARATOR));
        syntheseResource.setUrl(resource.getResourceUrl());
        if (syntheseResource.getUrl() != null) {
            syntheseResource.setUrl(this.computeURL(synthesis.getUserId(), syntheseResource.getUrl()));
        }
        syntheseResource.setLinkLabel(this.getResourceLinkLabel(resource));
        if (StringUtil.isDefined((String)resource.getAttachmentTargetId()) && StringUtil.isDefined((String)resource.getComponentInstanceId())) {
            ResourceReference attachmentTarget = new ResourceReference(resource.getAttachmentTargetId(), resource.getComponentInstanceId());
            List<AttachmentLink> attachmentLinks = AttachmentLink.getForContribution(attachmentTarget, language);
            syntheseResource.setAttachmentLinks(attachmentLinks);
        }
        boolean isPreviousHasMessage = false;
        for (DelayedNotificationData delayedNotificationData : notifications) {
            SyntheseResourceNotification syntheseNotification = new SyntheseResourceNotification();
            syntheseResource.addNotification(syntheseNotification);
            syntheseNotification.setAction(this.getResourceActionLabel(delayedNotificationData));
            syntheseNotification.setFromUserName(this.getUserDetail(delayedNotificationData.getFromUserId()).getDisplayedName());
            syntheseNotification.setDate(DateUtil.getOutputDate((Date)delayedNotificationData.getCreationDate(), (String)language));
            syntheseNotification.setTime(DateUtil.getOutputHour((Date)delayedNotificationData.getCreationDate(), (String)language));
            syntheseNotification.setMessage(DelayedNotificationDelegate.nullIfBlank(delayedNotificationData.getMessage()));
            syntheseNotification.setPreviousHasMessage(isPreviousHasMessage);
            if (syntheseNotification.getMessage() != null) {
                isPreviousHasMessage = true;
                syntheseNotification.setMessage(this.forHtml(syntheseNotification.getMessage()));
            } else {
                isPreviousHasMessage = false;
            }
            synthesis.getDelayedNotificationIdProceeded().add(Long.parseLong(delayedNotificationData.getId()));
        }
    }

    @Nonnull
    private String getResourceActionLabel(DelayedNotificationData delayedNotificationData) {
        String label = this.getStringTranslation("resourceAction" + delayedNotificationData.getAction().name(), delayedNotificationData.getResource().getCurrentLanguage());
        if (!delayedNotificationData.getResource().isFeminineGender()) {
            label = label.replace("\u00e9e", "\u00e9");
        }
        return label;
    }

    @Nonnull
    private String getResourceLinkLabel(NotificationResourceData resource) {
        String defaultLinkLabel = this.getStringTranslation("contribution.notifEventLinkLabel", resource.getCurrentLanguage());
        return StringUtil.defaultStringIfNotDefined((String)resource.getLinkLabel(), (String)defaultLinkLabel);
    }

    private static String nullIfBlank(String string) {
        return StringUtils.isBlank((CharSequence)string) ? null : string;
    }

    private String buildMessage(DelayedNotificationSyntheseData syntheses) {
        this.clearTemplate();
        UserDetail user = this.getUserDetail(syntheses.getUserId());
        this.getTemplate().setAttribute(NotificationTemplateKey.NOTIFICATION_BASE_SERVER_URL.toString(), (Object)this.getUserAutoRedirectServerURL(user.getId()));
        this.getTemplate().setAttribute(NotificationTemplateKey.NOTIFICATION_SERVER_URL.toString(), (Object)this.getUserAutoRedirectSilverpeasServerURL(user.getId()));
        this.getTemplate().setAttribute("delay", (Object)this.getStringTranslation("delay" + syntheses.getFrequency().name(), syntheses.getLanguage()));
        this.getTemplate().setAttribute("userName", (Object)user.getDisplayedName());
        this.getTemplate().setAttribute("nbResources", (Object)syntheses.getNbResources());
        this.getTemplate().setAttribute("severalResources", (Object)(syntheses.getNbResources() > 1 ? 1 : 0));
        this.getTemplate().setAttribute("nbNotifications", (Object)syntheses.getNbNotifications());
        this.getTemplate().setAttribute("severalNotifications", (Object)(syntheses.getNbNotifications() > 1 ? 1 : 0));
        this.getTemplate().setAttribute("resources", syntheses.getResources());
        return this.getTemplate().applyFileTemplate("messageLayout_" + syntheses.getLanguage());
    }

    private String buildSubject(DelayedNotificationSyntheseData synthese) {
        this.clearTemplate();
        this.getTemplate().setAttribute("frequency", (Object)this.getStringTranslation("frequency" + synthese.getFrequency().name(), synthese.getLanguage()));
        return this.getTemplate().applyFileTemplate("subject_" + synthese.getLanguage());
    }

    private void clearTemplate() {
        this.getTemplate().getAttributes().clear();
    }

    private SilverpeasTemplate getTemplate() {
        if (this.template == null) {
            this.template = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"notification/delayed").mergeRootWithCustom();
        }
        return this.template;
    }

    private DelayedNotificationSyntheseData initializeSynthese(List<DelayedNotificationData> delayedNotifications) {
        DelayedNotificationSyntheseData synthese = new DelayedNotificationSyntheseData();
        DelayedNotificationData first = delayedNotifications.get(0);
        synthese.setUserId(first.getUserId());
        synthese.setFrequency(DelayedNotificationProvider.getDelayedNotification().getUserFrequency(first.getUserId(), first.getChannel()));
        synthese.setLanguage(first.getLanguage());
        synthese.setSubject(this.buildSubject(synthese));
        return synthese;
    }

    private NotificationData createNotificationData(NotifChannel channel, DelayedNotificationSyntheseData syntheses) {
        NotificationData notificationData = new NotificationData();
        UserDetail receiver = this.getUserDetail(syntheses.getUserId());
        UserDetail sender = this.getUserDetail(-1);
        notificationData.setTargetChannel(channel.name());
        notificationData.setTargetReceipt(NotifChannel.SMTP.equals((Object)channel) ? receiver.getEmailAddress() : Integer.toString(syntheses.getUserId()));
        notificationData.setSenderName(sender.getDisplayedName());
        notificationData.setTargetParam(new HashMap());
        notificationData.getTargetParam().put(NotificationParameterNames.FROM.toString(), NotifChannel.SMTP.equals((Object)channel) ? sender.getEmailAddress() : sender.getId());
        notificationData.getTargetParam().put(NotificationParameterNames.SUBJECT.toString(), syntheses.getSubject());
        notificationData.getTargetParam().put(NotificationParameterNames.DATE.toString(), new Date());
        notificationData.getTargetParam().put(NotificationParameterNames.LANGUAGE.toString(), syntheses.getLanguage());
        notificationData.getTargetParam().put(NotificationParameterNames.HIDESMTPHEADERFOOTER.toString(), true);
        notificationData.setMessage(syntheses.getMessage());
        notificationData.setAnswerAllowed(false);
        return notificationData;
    }

    private String getStringTranslation(String key, String language) {
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationManager.multilang.notificationManagerBundle", (String)language);
        return messages.getString(key);
    }

    private Comparator<NotificationResourceData> getResourceComparator() {
        if (this.resourceComparator == null) {
            this.resourceComparator = new AbstractComplexComparator<NotificationResourceData>(){

                @Override
                protected AbstractComplexComparator.ValueBuffer getValuesToCompare(NotificationResourceData object) {
                    return new AbstractComplexComparator.ValueBuffer().append(object.getResourceLocation()).append(object.getResourceType()).append(object.getResourceName()).append(object.getResourceDescription()).append(object.getComponentInstanceId());
                }
            };
        }
        return this.resourceComparator;
    }

    private Comparator<DelayedNotificationData> getDelayedNotificationComparator() {
        if (this.delayedNotificationComparator == null) {
            this.delayedNotificationComparator = new AbstractComplexComparator<DelayedNotificationData>(){

                @Override
                protected AbstractComplexComparator.ValueBuffer getValuesToCompare(DelayedNotificationData object) {
                    return new AbstractComplexComparator.ValueBuffer().append(object.getCreationDate()).append(object.getAction().getPriority());
                }
            };
        }
        return this.delayedNotificationComparator;
    }

    protected UserDetail getUserDetail(Integer userId) {
        UserDetail userDetail = this.userDetailCache.get(userId);
        if (userDetail == null) {
            if (userId >= 0) {
                userDetail = this.getUserDetail(Integer.toString(userId));
            } else {
                Administration admin = AdministrationServiceProvider.getAdminService();
                userDetail = new UserDetail();
                userDetail.setId(Integer.toString(userId));
                userDetail.setLastName(admin.getSilverpeasName());
                userDetail.setEmailAddress(admin.getSilverpeasEmail());
            }
            if (this.userDetailCache.size() >= 100) {
                this.userDetailCache.remove(this.userDetailCache.keySet().iterator().next());
            }
            this.userDetailCache.put(userId, userDetail);
        }
        return userDetail;
    }

    private UserDetail getUserDetail(String userId) {
        try {
            return Administration.get().getUserDetail(userId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return null;
        }
    }

    protected void sendNotification(NotificationData notificationData) throws NotificationServerException {
        notificationData.setMessage(notificationData.getMessage().replaceAll("[\r\n\t]", ""));
        NotificationServer notificationServer = NotificationServer.get();
        notificationServer.addNotification(notificationData);
    }

    private String forHtml(String content) {
        return WebEncodeHelper.convertBlanksForHtml((String)content);
    }
}

