/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.notification.user.client.model.SentNotificationDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.LongText;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

public class SentNotificationDAO {
    private static final String COLUMNS = "notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveNotifUser(Connection con, SentNotificationDetail notif) {
        PreparedStatement prepStmt = null;
        int notifId = 0;
        try {
            String query = "insert into ST_NotifSended (notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body) values (?,?,?,?,?,?,?,?,?)";
            prepStmt = con.prepareStatement(query);
            notifId = DBUtil.getNextId((String)"ST_NotifSended", (String)"notifId");
            prepStmt.setInt(1, notifId);
            prepStmt.setInt(2, notif.getUserId());
            prepStmt.setInt(3, notif.getMessageType());
            Date notifDate = notif.getNotifDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(notifDate);
            prepStmt.setString(4, Long.toString(calendar.getTime().getTime()));
            prepStmt.setString(5, notif.getTitle());
            prepStmt.setString(6, notif.getLink());
            prepStmt.setString(7, notif.getSessionId());
            prepStmt.setString(8, notif.getComponentId());
            int bodyId = LongText.addLongText((String)notif.getBody());
            prepStmt.setInt(9, bodyId);
            prepStmt.executeUpdate();
            for (String userId : notif.getUsers()) {
                SentNotificationDAO.saveReceiver(con, notifId, Integer.parseInt(userId));
            }
        }
        catch (Exception e) {
            int n;
            try {
                n = 0;
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
            DBUtil.close((Statement)prepStmt);
            return n;
        }
        DBUtil.close((Statement)prepStmt);
        return notifId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SentNotificationDetail> getAllNotifByUser(Connection con, String userId) throws SQLException {
        ArrayList<SentNotificationDetail> notifs = new ArrayList<SentNotificationDetail>();
        ArrayList<Integer> longTextIds = new ArrayList<Integer>();
        String query = "select notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body from ST_NotifSended where userId = ? order by notifId desc";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SentNotificationDetail notif = SentNotificationDAO.convertFromWithoutBody(rs);
                longTextIds.add(rs.getInt("body"));
                notifs.add(notif);
            }
            Mutable offset = Mutable.of((Object)0);
            CollectionUtil.splitList(longTextIds).forEach(batchIds -> {
                Map contents = LongText.listLongTexts((Collection)batchIds);
                int n = (Integer)offset.get();
                for (int c = 0; c < batchIds.size(); ++c) {
                    SentNotificationDetail notif = (SentNotificationDetail)notifs.get(n);
                    notif.setBody((String)contents.get(batchIds.get(c)));
                    ++n;
                }
                offset.set((Object)((Integer)offset.get() + batchIds.size()));
            });
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return notifs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getReceivers(Connection con, int notifId) throws SQLException {
        ArrayList<String> users = new ArrayList<String>();
        String query = "select userId from ST_NotifSendedReceiver where notifId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                users.add(Integer.toString(rs.getInt("userId")));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SentNotificationDetail getNotif(Connection con, int notifId) throws SQLException {
        SentNotificationDetail notif = null;
        String query = "select notifId, userId, messageType, notifDate, title, link, sessionId, componentId, body from ST_NotifSended where notifId = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                notif = SentNotificationDAO.convertFrom(rs);
                notif.setUsers(SentNotificationDAO.getReceivers(con, notifId));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return notif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteNotif(Connection con, int notifId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            JdbcSqlQuery.deleteFrom((String)"ST_LongText").where("id = (select body from ST_NotifSended where notifId = ?)", new Object[]{notifId}).executeWith(con);
            SentNotificationDAO.deleteReceivers(con, notifId);
            String query = "delete from ST_NotifSended where notifId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteReceivers(Connection con, int notifId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "delete from ST_NotifSendedReceiver where notifId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveReceiver(Connection con, int notifId, int userId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "insert into ST_NotifSendedReceiver (notifId, userId) values (?,?) ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, notifId);
            prepStmt.setInt(2, userId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static void deleteNotifByUser(Connection con, String userId) throws SQLException {
        List<SentNotificationDetail> notifs = SentNotificationDAO.getAllNotifByUser(con, userId);
        for (SentNotificationDetail notif : notifs) {
            SentNotificationDAO.deleteNotif(con, notif.getNotifId());
        }
    }

    private static SentNotificationDetail convertFromWithoutBody(ResultSet rs) throws SQLException {
        SentNotificationDetail notif = new SentNotificationDetail();
        notif.setNotifId(rs.getInt("notifId"));
        notif.setUserId(rs.getInt("userId"));
        notif.setMessageType(rs.getInt("messageType"));
        String date = rs.getString("notifDate");
        if (StringUtil.isDefined((String)date)) {
            try {
                notif.setNotifDate(new Date(Long.parseLong(date)));
            }
            catch (NumberFormatException e) {
                notif.setNotifDate(new Date());
            }
        } else {
            notif.setNotifDate(new Date());
        }
        notif.setTitle(rs.getString("title"));
        notif.setLink(rs.getString("link"));
        notif.setSessionId(rs.getString("sessionId"));
        notif.setComponentId(rs.getString("componentId"));
        return notif;
    }

    private static SentNotificationDetail convertFrom(ResultSet rs) throws SQLException {
        SentNotificationDetail notif = SentNotificationDAO.convertFromWithoutBody(rs);
        String body2 = "";
        try {
            body2 = LongText.getLongText((int)rs.getInt("body"));
        }
        catch (Exception e) {
            SilverLogger.getLogger(SentNotificationDAO.class).warn((Throwable)e);
        }
        notif.setBody(body2);
        return notif;
    }
}

