/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.CurrentUserNotificationContext;
import org.silverpeas.core.notification.user.client.NotificationManager;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationParameters;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.model.SentNotificationInterface;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.StringUtil;

public class NotificationSender
implements Serializable {
    private static final long serialVersionUID = 4165938893905145809L;
    private final transient NotificationManager notificationManager;
    private final int instanceId;

    protected NotificationSender() {
        this(null);
    }

    public NotificationSender(String instanceId) {
        this.instanceId = ComponentInst.getComponentLocalId(instanceId);
        this.notificationManager = NotificationManager.get();
    }

    public void notifyUser(NotificationMetaData metaData) throws NotificationException {
        this.notifyUser(BuiltInNotifAddress.COMPONENT_DEFINED.getId(), metaData);
    }

    public void notifyUser(int addressId, NotificationMetaData metaData) throws NotificationException {
        CurrentUserNotificationContext.getCurrentUserNotificationContext().checkManualUserNotification(metaData);
        Set recipients = metaData.getAllUserRecipients(true);
        Set languages = metaData.getLanguages();
        Set<String> recipientIds = recipients.stream().map(UserRecipient::getUserId).collect(Collectors.toSet());
        if (languages.size() == 1) {
            this.sendNotification(recipientIds, metaData, addressId, (String)languages.iterator().next());
        } else {
            String defaultLanguage = this.getDefaultLanguage(metaData.getSender(), languages);
            HashMap usersPerLanguage = new HashMap();
            recipientIds.stream().map(User::getById).forEach(u -> {
                String userLang = u.getUserPreferences().getLanguage();
                if (languages.contains(userLang)) {
                    this.addUserForLanguage(usersPerLanguage, (User)u, userLang);
                } else {
                    this.addUserForLanguage(usersPerLanguage, (User)u, defaultLanguage);
                }
            });
            for (Map.Entry entry : usersPerLanguage.entrySet()) {
                this.sendNotification((Collection)entry.getValue(), metaData, addressId, (String)entry.getKey());
            }
        }
        this.sendNotification(Collections.emptySet(), metaData, addressId, metaData.getExternalLanguage());
        if (metaData.isSendByAUser()) {
            this.saveNotification(metaData, recipients);
        }
    }

    private void addUserForLanguage(Map<String, Set<String>> usersPerLanguage, User u, String userLang) {
        usersPerLanguage.compute(userLang, (l, s) -> {
            HashSet<String> users = s;
            if (users == null) {
                users = new HashSet<String>();
            }
            users.add(u.getId());
            return users;
        });
    }

    private String getDefaultLanguage(String senderId, Collection<String> languages) {
        String senderLanguage = "";
        if (StringUtil.isDefined((String)senderId)) {
            senderLanguage = User.getById((String)senderId).getUserPreferences().getLanguage();
        }
        String defaultLanguage = languages.contains(senderLanguage) ? senderLanguage : (languages.contains(I18NHelper.DEFAULT_LANGUAGE) ? I18NHelper.DEFAULT_LANGUAGE : languages.iterator().next());
        return defaultLanguage;
    }

    private void sendNotification(Collection<String> userIds, NotificationMetaData metaData, int addressId, String language) throws NotificationException {
        NotificationParameters params = this.getNotificationParameters(addressId, metaData);
        params.setTitle(metaData.getTitle(language)).setLink(metaData.getLink(language)).setMessage(metaData.getContent(language)).setLanguage(language);
        if (!userIds.isEmpty()) {
            params.setNotificationResourceData(metaData.getNotificationResourceData(language));
            this.notificationManager.notifyUsers(params, userIds);
        } else if (CollectionUtil.isNotEmpty((Collection)metaData.getExternalRecipients())) {
            this.notificationManager.notifyExternals(params, metaData.getExternalRecipients());
            metaData.setExternalRecipients(null);
        }
    }

    private void saveNotification(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationException {
        if (!usersSet.isEmpty()) {
            this.getNotificationInterface().saveNotifUser(metaData, usersSet);
        }
    }

    private SentNotificationInterface getNotificationInterface() {
        return SentNotificationInterface.get();
    }

    private NotificationParameters getNotificationParameters(int aMediaType, NotificationMetaData metaData) {
        NotificationParameters params = new NotificationParameters();
        params.setMessagePriority(metaData.getMessageType()).setDate(metaData.getDate()).setTitle(metaData.getTitle()).setMessage(metaData.getContent()).setSource(metaData.getSource()).setSessionId(metaData.getSessionId()).setOriginalExtraMessage(metaData.getOriginalExtraMessage()).setSendImmediately(metaData.isSendImmediately()).setAddressId(aMediaType).setAnswerAllowed(metaData.isAnswerAllowed()).setAction(metaData.getAction());
        if (this.instanceId != -1) {
            params.setComponentInstance(this.instanceId);
        } else {
            params.setComponentInstance(ComponentInst.getComponentLocalId(metaData.getComponentId()));
        }
        String sender = metaData.getSender();
        if (aMediaType == BuiltInNotifAddress.BASIC_POPUP.getId()) {
            if (metaData.isAnswerAllowed() && StringUtil.isInteger((String)sender)) {
                params.setFromUserId(Integer.parseInt(metaData.getSender()));
            }
        } else if (StringUtil.isInteger((String)sender)) {
            params.setFromUserId(Integer.parseInt(metaData.getSender()));
        } else {
            params.setSenderName(sender);
        }
        return params;
    }
}

