/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.model;

import java.io.Serializable;
import java.util.Objects;
import org.silverpeas.core.ResourceReference;

public class NodePK
extends ResourceReference
implements Serializable {
    private static final long serialVersionUID = 444396186497175804L;
    public static final String UNDEFINED_NODE_ID = "-1";
    public static final String ROOT_NODE_ID = "0";
    public static final String BIN_NODE_ID = "1";
    public static final String UNCLASSED_NODE_ID = "2";

    public NodePK(String id) {
        super(id);
    }

    public NodePK(String id, String space, String componentName) {
        super(id, componentName);
        this.setSpace(space);
    }

    public NodePK(String id, String componentId) {
        super(id, componentId);
    }

    public NodePK(String id, ResourceReference pk) {
        this(id, pk.getSpace(), pk.getInstanceId());
    }

    public boolean isTrash() {
        return BIN_NODE_ID.equals(this.id);
    }

    public boolean isRoot() {
        return ROOT_NODE_ID.equals(this.id);
    }

    public boolean isUnclassed() {
        return UNCLASSED_NODE_ID.equals(this.id);
    }

    public boolean isUndefined() {
        return UNDEFINED_NODE_ID.equals(this.id);
    }

    public String getRootTableName() {
        return "Node";
    }

    public String getTableName() {
        return "SB_Node_Node";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodePK)) {
            return false;
        }
        NodePK other = (NodePK)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.getComponentInstanceId(), other.getComponentInstanceId());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getComponentInstanceId());
    }
}

