/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.importexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.node.importexport.NodeTreeType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;

@Service
public class NodeImportExport {
    @Inject
    private NodeService nodeService;

    protected NodeImportExport() {
    }

    public Collection<NodeDetail> getPathOfNode(NodePK nodePk) {
        return this.getNodeService().getPath(nodePk);
    }

    public List<NodeTreeType> getTrees(List<String> listComponentId) {
        ArrayList<NodeTreeType> listNodeTreeType = new ArrayList<NodeTreeType>(listComponentId.size());
        for (String componentId : listComponentId) {
            NodeTreeType nodeTreeType = new NodeTreeType();
            listNodeTreeType.add(nodeTreeType);
            nodeTreeType.setComponentId(componentId);
            NodePK nodePK = new NodePK("0", "useless", componentId);
            NodeDetail nodeDetail = this.getNodeService().getDetail(nodePK);
            nodeTreeType.setNodeDetail(nodeDetail);
            nodeDetail.setChildrenDetails(this.getRecursiveTree(nodePK));
        }
        return listNodeTreeType;
    }

    private Collection<NodeDetail> getRecursiveTree(NodePK nodePK) {
        Collection<NodeDetail> listChildrenDetails = this.getNodeService().getChildrenDetails(nodePK);
        if (listChildrenDetails != null && !listChildrenDetails.isEmpty()) {
            for (NodeDetail nodeDetail : listChildrenDetails) {
                nodeDetail.setChildrenDetails(this.getRecursiveTree(nodeDetail.getNodePK()));
            }
        } else {
            listChildrenDetails = null;
        }
        return listChildrenDetails;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }
}

