/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.upload;

import java.io.File;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.io.upload.UploadSession;
import org.silverpeas.core.io.upload.UploadedFileItem;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.util.StringUtil;

public class UploadedFile {
    private final UploadSession uploadSession;
    private final File file;
    private final String title;
    private final String description;
    private final String uploader;

    public static UploadedFile from(Map<String, String[]> parameters, String uploadSessionId, User uploader) {
        UploadSession uploadSession = UploadSession.from(uploadSessionId);
        return new UploadedFile(uploadSession, UploadedFile.getUploadedFile(uploadSession), parameters.get(uploadSessionId + "-title")[0], parameters.get(uploadSessionId + "-description")[0], uploader.getId());
    }

    private UploadedFile(UploadSession uploadSession, File file, String title, String description, String uploader) {
        this.uploadSession = uploadSession;
        this.file = file;
        this.title = title;
        this.description = description;
        this.uploader = uploader;
    }

    public UploadSession getUploadSession() {
        return this.uploadSession;
    }

    public File getFile() {
        return this.file;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public FileItem asFileItem() {
        return new UploadedFileItem(this);
    }

    private void markAsProcessed() {
        this.uploadSession.clear();
    }

    public void registerAttachment(ContributionIdentifier contributionId, String contributionLanguage, boolean indexIt) {
        this.registerAttachment(contributionId.getLocalId(), contributionId.getComponentInstanceId(), contributionLanguage, indexIt);
    }

    private void registerAttachment(String resourceId, String componentInstanceId, String contributionLanguage, boolean indexIt) {
        SimpleDocument document = this.createSimpleDocument(new ResourceReference(resourceId, componentInstanceId), contributionLanguage);
        AttachmentServiceProvider.getAttachmentService().createAttachment(document, this.getFile(), indexIt, false);
        this.markAsProcessed();
    }

    private SimpleDocument createSimpleDocument(ResourceReference contribution, String contributionLanguage) {
        String lang = I18NHelper.checkLanguage(contributionLanguage);
        String theTitle = StringUtil.defaultStringIfNotDefined((String)this.getTitle());
        String theDescription = StringUtil.defaultStringIfNotDefined((String)this.getDescription());
        if (AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled() && !StringUtil.isDefined((String)theTitle)) {
            MetadataExtractor extractor = MetadataExtractor.get();
            MetaData metadata = extractor.extractMetadata(this.getFile());
            if (StringUtil.isDefined((String)metadata.getTitle())) {
                theTitle = metadata.getTitle();
            }
            if (!StringUtil.isDefined((String)theDescription) && StringUtil.isDefined((String)metadata.getSubject())) {
                theDescription = metadata.getSubject();
            }
        }
        SimpleDocumentPK pk = new SimpleDocumentPK(null, (WAPrimaryKey)contribution);
        SimpleAttachment attachment = SimpleAttachment.builder(lang).setFilename(this.getFile().getName()).setTitle(theTitle).setDescription(theDescription).setSize(this.getFile().length()).setContentType(FileUtil.getMimeType(this.getFile().getPath())).setCreationData(this.uploader, DateUtil.getNow()).build();
        SimpleDocument document = new SimpleDocument(pk, contribution.getId(), 0, false, null, attachment);
        document.setLanguage(lang);
        document.setTitle(theTitle);
        document.setDescription(theDescription);
        document.setSize(this.getFile().length());
        return document;
    }

    private static File getUploadedFile(UploadSession uploadSession) {
        File[] files = uploadSession.getRootFolderFiles();
        if (files.length != 1) {
            return new File(FileRepositoryManager.getTemporaryPath(), "unexistingFile");
        }
        return files[0];
    }
}

