/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.temp;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.io.temp.LastModifiedDateFileTask;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.SerializationUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class TemporaryWorkspaceTranslation {
    private static final String TRANSLATION_ID = "__sptrans_id";
    private static final String SILVERPEAS_TRANSLATION_PREFIX = "__sptrans_";
    private final File descriptor;
    private File workspace;
    private Map<String, String> descriptorContent = new HashMap<String, String>();
    private boolean workInProgress = false;
    private Object lock = new Object();

    public static boolean startWithTranslationDescriptorPrefix(String path) {
        return StringUtil.isDefined((String)path) && path.replaceAll("^/", "").startsWith(SILVERPEAS_TRANSLATION_PREFIX);
    }

    public static TemporaryWorkspaceTranslation from(String identifier) {
        return new TemporaryWorkspaceTranslation(identifier);
    }

    private TemporaryWorkspaceTranslation(String id) {
        this.descriptor = new File(FileRepositoryManager.getTemporaryPath(), this.checkedPath(SILVERPEAS_TRANSLATION_PREFIX + id));
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.descriptor.isFile() && this.descriptor.length() > 30L) {
                try {
                    for (String line : FileUtils.readLines((File)this.descriptor, (Charset)Charsets.UTF_8)) {
                        int splitIndex = line.indexOf(61);
                        if (splitIndex <= 0) continue;
                        this.descriptorContent.put(line.substring(0, splitIndex), line.substring(splitIndex + 1));
                    }
                }
                catch (IOException e) {
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            } else {
                this.descriptorContent.put(TRANSLATION_ID, UUID.randomUUID().toString());
            }
            this.workspace = new File(FileRepositoryManager.getTemporaryPath(), this.checkedPath(this.descriptorContent.get(TRANSLATION_ID)));
        }
    }

    private String checkedPath(String path) {
        String pathToCheck = StringUtil.defaultStringIfNotDefined((String)path, (String)"unknown");
        if (pathToCheck.contains("..")) {
            String errorMsg = MessageFormat.format("Path Traversal attack detected at {0}", LocalDateTime.now());
            SilverLogger.getLogger((String)"silverpeas.core.security").error(errorMsg, new Object[0]);
            throw new SilverpeasRuntimeException(errorMsg);
        }
        return pathToCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        Object object = this.lock;
        synchronized (object) {
            boolean result = FileUtils.deleteQuietly((File)this.workspace) && FileUtils.deleteQuietly((File)this.descriptor);
            this.initialize();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        Object object = this.lock;
        synchronized (object) {
            return this.descriptor.isFile() && this.descriptor.length() > 30L && this.workspace.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean empty() {
        Object object = this.lock;
        synchronized (object) {
            return this.exists() && FileUtils.sizeOfDirectory((File)this.workspace) == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified() {
        Object object = this.lock;
        synchronized (object) {
            return this.exists() ? this.descriptor.lastModified() : 0L;
        }
    }

    public void updateLastModifiedDate() {
        LastModifiedDateFileTask.addFile(this.descriptor);
        LastModifiedDateFileTask.addFile(this.workspace);
    }

    public File getRootPath() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.exists()) {
                this.workspace.mkdirs();
                this.saveDescriptor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptor() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.descriptorContent.containsKey(TRANSLATION_ID)) {
                    StringBuilder content = new StringBuilder();
                    for (Map.Entry<String, String> line : this.descriptorContent.entrySet()) {
                        if (content.length() > 0) {
                            content.append("\n");
                        }
                        content.append(line.getKey()).append("=").append(line.getValue());
                    }
                    FileUtils.writeStringToFile((File)this.descriptor, (String)content.toString(), (Charset)Charsets.UTF_8);
                }
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markWorkInProgress() {
        Object object = this.lock;
        synchronized (object) {
            this.workInProgress = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markWorkNoMoreInProgress() {
        Object object = this.lock;
        synchronized (object) {
            this.workInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkInProgress() {
        Object object = this.lock;
        synchronized (object) {
            return this.workInProgress;
        }
    }

    public TemporaryWorkspaceTranslation put(String key, Serializable value) {
        if (value == null) {
            this.descriptorContent.remove(key);
        } else {
            this.descriptorContent.put(key, SerializationUtil.serializeAsString((Serializable)value));
        }
        if (this.exists()) {
            this.saveDescriptor();
        }
        this.markWorkNoMoreInProgress();
        return this;
    }

    public <T extends Serializable> T get(String key) {
        try {
            String value = this.descriptorContent.get(key);
            if (value == null) {
                return null;
            }
            return (T)SerializationUtil.deserializeFromString((String)this.descriptorContent.get(key));
        }
        catch (RuntimeException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.descriptor.getName() + " -> " + this.workspace.getName();
    }
}

