/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.temp;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.temp.TemporaryDataManagementSetting;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class TemporaryDataCleanerSchedulerInitializer
extends SchedulingInitializer {
    protected static final String JOB_NAME = "TemporayDataCleanerJob";
    private static final File tempPath = new File(FileRepositoryManager.getTemporaryPath());
    private Future<Void> startTask;
    private final TemporaryDataCleanerJob job = new TemporaryDataCleanerJob();

    protected void preSchedule() {
        this.startTask = this.job.startCleanProcess(TemporaryDataManagementSetting.getTimeAfterThatFilesMustBeDeletedAtServerStart());
    }

    @NonNull
    protected String getCron() {
        return TemporaryDataManagementSetting.getJobCron();
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return true;
    }

    Optional<Future<Void>> getStartTask() {
        return Optional.ofNullable(this.startTask);
    }

    static class CleaningObsoleteFileAndDirectoriesVisitor
    extends SimpleFileVisitor<Path> {
        private final Instant age;
        private final Set<Path> directoriesThatCanBeDeleted = new HashSet<Path>();
        private final SilverLogger logger = SilverLogger.getLogger((Object)this);
        private boolean rootVisited = false;
        private long nbDeletedFiles = 0L;
        private long nbDeletedDirectories = 0L;

        public CleaningObsoleteFileAndDirectoriesVisitor(ZonedDateTime age) {
            this.age = age.toInstant();
        }

        public long getNbDeletedFiles() {
            return this.nbDeletedFiles;
        }

        public long getNbDeletedDirectories() {
            return this.nbDeletedDirectories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public FileVisitResult preVisitDirectory(@NonNull Path dir, @NonNull BasicFileAttributes attrs) throws IOException {
            try {
                FileVisitResult fileVisitResult = super.preVisitDirectory(dir, attrs);
                return fileVisitResult;
            }
            finally {
                if (this.rootVisited && this.isObsolete(attrs)) {
                    this.directoriesThatCanBeDeleted.add(dir);
                }
                this.rootVisited = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public FileVisitResult visitFile(@NonNull Path file, @NonNull BasicFileAttributes attrs) throws IOException {
            FileVisitResult fileVisitResult;
            block7: {
                try {
                    fileVisitResult = super.visitFile(file, attrs);
                    if (!this.isObsolete(attrs)) break block7;
                }
                catch (Throwable throwable) {
                    if (this.isObsolete(attrs)) {
                        if (Files.deleteIfExists(file)) {
                            ++this.nbDeletedFiles;
                            this.logger.debug(() -> MessageFormat.format("Deleting file {0}", file.toFile().getPath()));
                        } else {
                            this.logger.warn(MessageFormat.format("Detecting file [{0}] for deletion, but it is not present when deleting it!", file.toFile().getPath()), new Object[0]);
                        }
                    }
                    throw throwable;
                }
                if (Files.deleteIfExists(file)) {
                    ++this.nbDeletedFiles;
                    this.logger.debug(() -> MessageFormat.format("Deleting file {0}", file.toFile().getPath()));
                } else {
                    this.logger.warn(MessageFormat.format("Detecting file [{0}] for deletion, but it is not present when deleting it!", file.toFile().getPath()), new Object[0]);
                }
            }
            return fileVisitResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public FileVisitResult postVisitDirectory(@NonNull Path dir, IOException exc) throws IOException {
            FileVisitResult fileVisitResult;
            block11: {
                try {
                    fileVisitResult = super.postVisitDirectory(dir, exc);
                    if (!this.directoriesThatCanBeDeleted.remove(dir)) break block11;
                }
                catch (Throwable throwable) {
                    if (this.directoriesThatCanBeDeleted.remove(dir)) {
                        try {
                            if (Files.deleteIfExists(dir)) {
                                ++this.nbDeletedDirectories;
                                this.logger.debug(() -> MessageFormat.format("Deleting directory {0}", dir.toFile().getPath()));
                            } else {
                                this.logger.warn(MessageFormat.format("Detecting directory [{0}] for deletion, but it is not present when deleting it!", dir.toFile().getPath()), new Object[0]);
                            }
                        }
                        catch (DirectoryNotEmptyException e) {
                            this.logger.silent((Throwable)e);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (Files.deleteIfExists(dir)) {
                        ++this.nbDeletedDirectories;
                        this.logger.debug(() -> MessageFormat.format("Deleting directory {0}", dir.toFile().getPath()));
                    } else {
                        this.logger.warn(MessageFormat.format("Detecting directory [{0}] for deletion, but it is not present when deleting it!", dir.toFile().getPath()), new Object[0]);
                    }
                }
                catch (DirectoryNotEmptyException e) {
                    this.logger.silent((Throwable)e);
                }
            }
            return fileVisitResult;
        }

        private boolean isObsolete(BasicFileAttributes attrs) {
            return attrs.lastModifiedTime().toInstant().isBefore(this.age);
        }
    }

    private static class CleaningProcess
    implements Callable<Void> {
        private final long millisecondOffset;

        private CleaningProcess(long millisecondOffset) {
            this.millisecondOffset = millisecondOffset;
        }

        @Override
        public Void call() {
            ZonedDateTime age = ZonedDateTime.now().minus(this.millisecondOffset, ChronoUnit.MILLIS);
            CleaningObsoleteFileAndDirectoriesVisitor visitor = new CleaningObsoleteFileAndDirectoriesVisitor(age);
            try {
                Files.walkFileTree(tempPath.toPath(), visitor);
                SilverLogger.getLogger((Object)this).info(MessageFormat.format("{0} file(s) and {1} directorie(s) deleted.", visitor.getNbDeletedFiles(), visitor.getNbDeletedDirectories()), new Object[0]);
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            return null;
        }
    }

    static class TemporaryDataCleanerJob
    extends Job {
        private final Object mutex = new Object();
        private final AtomicInteger nbAttempts = new AtomicInteger(0);
        private Future<Void> currentTask;

        public TemporaryDataCleanerJob() {
            super(TemporaryDataCleanerSchedulerInitializer.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            long nbMilliseconds = TemporaryDataManagementSetting.getTimeAfterThatFilesMustBeDeleted();
            if (nbMilliseconds < 0L) {
                nbMilliseconds = 0L;
            }
            this.startCleanProcess(nbMilliseconds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<Void> startCleanProcess(long nbMilliseconds) {
            Object object = this.mutex;
            synchronized (object) {
                if (!tempPath.exists() || nbMilliseconds < 0L) {
                    return null;
                }
                Future task = this.getSafelyCurrentTask();
                if (task != null && !task.isDone()) {
                    if (this.nbAttempts.incrementAndGet() > 1) {
                        this.nbAttempts.setRelease(0);
                        SilverLogger.getLogger((Object)((Object)this)).warn("Attempt for a second time to start a new cleaning process whereas an other one is not yet finished. Aborting the previous one to create a new process", new Object[0]);
                        task.cancel(true);
                    } else {
                        SilverLogger.getLogger((Object)((Object)this)).warn("Attempt to start a new cleaning process whereas an other one is not yet finished. New cleaning process is ignored", new Object[0]);
                        return task;
                    }
                }
                try {
                    this.currentTask = task = ManagedThreadPool.getPool().invoke((Callable)new CleaningProcess(nbMilliseconds));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
                }
                return task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Future<Void> getSafelyCurrentTask() {
            Object object = this.mutex;
            synchronized (object) {
                return this.currentTask;
            }
        }
    }
}

