/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.time.Duration;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Service
@Singleton
public class MetadataExtractor {
    private Tika tika;

    public static MetadataExtractor get() {
        return (MetadataExtractor)ServiceProvider.getService(MetadataExtractor.class, (Annotation[])new Annotation[0]);
    }

    MetadataExtractor() {
    }

    @PostConstruct
    protected void initialize() {
        this.tika = new Tika();
    }

    public MetaData extractMetadata(String filePath) {
        return this.extractMetadata(new File(filePath));
    }

    public MetaData extractMetadata(File file) {
        return this.apply(m -> this.getTikaService().parse(file, m));
    }

    public MetaData extractMetadata(InputStream content) {
        return this.apply(m -> this.getTikaService().parse(content, m));
    }

    private MetaData apply(MetadataFetcher fetcher) {
        MetaData metaData;
        block8: {
            Metadata metadata = new Metadata();
            Reader reader = fetcher.fetch(metadata);
            try {
                metaData = this.adjust(metadata);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)ex);
                    return new MetaData(new Metadata());
                }
            }
            reader.close();
        }
        return metaData;
    }

    private MetaData adjust(Metadata metaData) {
        this.adjustMediaDuration(metaData);
        return new MetaData(metaData);
    }

    private void adjustMediaDuration(Metadata metadata) {
        String durationData = metadata.get(XMPDM.DURATION);
        if (StringUtil.isDefined((String)durationData)) {
            try {
                Duration duration = UnitUtil.getDuration((BigDecimal)new BigDecimal(durationData), (TimeUnit)TimeUnit.SECOND);
                metadata.set(XMPDM.DURATION, String.valueOf(duration.getTimeAsLong()));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
    }

    public String detectMimeType(File file) throws IOException {
        return this.getTikaService().detect(file);
    }

    private Tika getTikaService() {
        return this.tika;
    }

    @FunctionalInterface
    private static interface MetadataFetcher {
        public Reader fetch(Metadata var1) throws IOException;
    }
}

