/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.io.file.SilverpeasFileProcessor;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasFile
extends File {
    private static final long serialVersionUID = -7236431331553364723L;
    public static final SilverpeasFile NO_FILE = new SilverpeasFile("", "", "");
    private final String instanceId;
    private final String mimeType;

    protected SilverpeasFile(String componentId, String path) {
        this(componentId, path, FileUtil.getMimeType(path));
    }

    protected SilverpeasFile(String componentId, String path, String mimeType) {
        super(path);
        this.instanceId = componentId;
        this.mimeType = StringUtil.isDefined((String)mimeType) ? mimeType : (path.isEmpty() ? "" : FileUtil.getMimeType(path));
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getComponentInstanceId() {
        return this.instanceId;
    }

    @Override
    public boolean exists() {
        return this != NO_FILE && super.exists();
    }

    @Override
    public boolean delete() {
        boolean deleted = false;
        if (this.exists()) {
            try {
                Files.delete(this.toPath());
                deleted = true;
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
            SilverpeasFileProvider.processAfter(this, SilverpeasFileProcessor.ProcessingContext.DELETION);
        }
        return deleted;
    }

    public InputStream inputStream() throws IOException {
        return new BufferedInputStream(FileUtils.openInputStream((File)this));
    }

    public void writeFrom(InputStream stream) throws IOException {
        File parentFile = this.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("The '" + String.valueOf(parentFile) + "' directory cannot be created!");
        }
        if (!this.exists()) {
            Files.createFile(this.toPath(), new FileAttribute[0]);
        }
        if (!this.canWrite()) {
            throw new IOException("The file'" + this.getPath() + "' is read-only!");
        }
        if (!this.exists()) {
            Files.createFile(this.toPath(), new FileAttribute[0]);
        }
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)this);
        SilverpeasFileProvider.processAfter(this, SilverpeasFileProcessor.ProcessingContext.WRITING);
    }

    public SilverpeasFile moveInto(String directoryPath) throws IOException {
        SilverpeasFile movedFile = NO_FILE;
        if (this.exists()) {
            FileUtils.moveFileToDirectory((File)this, (File)new File(directoryPath), (boolean)true);
            movedFile = new SilverpeasFile(this.getComponentInstanceId(), directoryPath + File.separatorChar + this.getName(), this.getMimeType());
            SilverpeasFileProvider.processAfter(movedFile, SilverpeasFileProcessor.ProcessingContext.MOVING);
        }
        return movedFile;
    }

    public SilverpeasFile copyInto(String directoryPath) throws IOException {
        SilverpeasFile copiedFile = NO_FILE;
        if (this.exists()) {
            FileUtils.copyFileToDirectory((File)this, (File)new File(directoryPath), (boolean)true);
            copiedFile = new SilverpeasFile(this.getComponentInstanceId(), directoryPath + File.separatorChar + this.getName(), this.getMimeType());
            SilverpeasFileProvider.processAfter(copiedFile, SilverpeasFileProcessor.ProcessingContext.COPY);
        }
        return copiedFile;
    }

    public boolean isArchive() {
        return FileUtil.isArchive(this.getPath());
    }

    public boolean isImage() {
        return FileUtil.isImage(this.getPath());
    }

    public boolean isMail() {
        return FileUtil.isMail(this.getPath());
    }

    public boolean isPdf() {
        return FileUtil.isPdf(this.getPath());
    }

    public boolean isOpenOfficeCompatible() {
        return FileUtil.isOpenOfficeCompatible(this.getPath());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

