/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.parser.tika;

import org.apache.tika.exception.TikaException;
import org.apache.tika.utils.XMLReaderUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
public class TikaInitialization
implements Initialization {
    public void init() {
        SettingBundle settingBundle = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.indexing.IndexEngine");
        int poolSize = settingBundle.getInteger("tika.saxParserPoolSize", 10);
        try {
            XMLReaderUtils.setPoolSize((int)poolSize);
        }
        catch (TikaException e) {
            IndexingLogger.indexingLogger().error("Failure while setting the size of the SAX parsers pool to " + poolSize + ". Rollback to the default pool size (10)", (Throwable)e);
            TikaInitialization.setDefaultPoolSize();
        }
    }

    private static void setDefaultPoolSize() {
        try {
            XMLReaderUtils.setPoolSize((int)10);
        }
        catch (TikaException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

