/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public class IndexEntry
implements Serializable {
    private static final long serialVersionUID = -4817004188601716658L;
    public static final String START_DATE_DEFAULT = "19000101";
    public static final String END_DATE_DEFAULT = "24001231";
    private IndexEntryKey pk;
    private String lang = null;
    private String creationDate = null;
    private String creationUser = null;
    private String lastModificationDate = null;
    private String lastModificationUser = null;
    private String startDate = null;
    private String endDate = null;
    private boolean indexId = false;
    private String thumbnail = null;
    private String thumbnailMimeType = null;
    private String thumbnailDirectory = null;
    private Map<String, String> titles = null;
    private Map<String, String> previews = null;
    private Map<String, String> keywordsI18N = null;
    private String serverName = null;
    private String filename = null;
    private List<String> paths = null;
    private boolean alias = false;

    public IndexEntry(IndexEntryKey pk) {
        this.pk = pk;
    }

    IndexEntry(IndexEntry other) {
        this.pk = new IndexEntryKey(other.pk);
        this.lang = other.lang;
        this.creationDate = other.creationDate;
        this.creationUser = other.creationUser;
        this.lastModificationDate = other.lastModificationDate;
        this.lastModificationUser = other.lastModificationUser;
        this.startDate = other.startDate;
        this.endDate = other.endDate;
        this.indexId = other.indexId;
        this.thumbnail = other.thumbnail;
        this.thumbnailMimeType = other.thumbnailMimeType;
        this.thumbnailDirectory = other.thumbnailDirectory;
        this.titles = other.titles != null ? new HashMap<String, String>(other.titles) : null;
        this.previews = other.previews != null ? new HashMap<String, String>(other.previews) : null;
        this.keywordsI18N = other.keywordsI18N != null ? new HashMap<String, String>(other.keywordsI18N) : null;
        this.serverName = other.serverName;
        this.filename = other.filename;
        this.paths = other.paths != null ? new ArrayList<String>(other.paths) : null;
        this.alias = other.alias;
    }

    public String toString() {
        return this.pk == null ? "" : this.pk.toString();
    }

    public IndexEntryKey getPK() {
        return this.pk;
    }

    public String getComponent() {
        return this.pk.getComponentId();
    }

    public String getObjectType() {
        return this.pk.getObjectType();
    }

    public String getObjectId() {
        return this.pk.getObjectId();
    }

    public String getLinkedObjectId() {
        return this.pk.getLinkedObjectId();
    }

    public void setTitle(String title) {
        this.setTitle(title, null);
    }

    public void setTitle(String title, String lang) {
        if (title != null) {
            this.getTitles().put(I18NHelper.checkLanguage(lang), title);
        }
    }

    public String getTitle() {
        if (this.getTitle(null) != null) {
            return this.getTitle(null);
        }
        return "";
    }

    public String getTitle(String lang) {
        return this.getTranslation(this.getTitles(), lang);
    }

    public void setKeywords(String keywords) {
        this.setKeywords(keywords, null);
    }

    public void setKeywords(String keywords, String lang) {
        if (keywords != null) {
            this.getAllKeywords().put(I18NHelper.checkLanguage(lang), keywords);
        }
    }

    public String getKeywords() {
        if (this.getKeywords(null) != null) {
            return this.getKeywords(null);
        }
        return "";
    }

    public String getKeywords(String lang) {
        return this.getTranslation(this.getAllKeywords(), lang);
    }

    public void setPreview(String preview) {
        this.setPreview(preview, null);
    }

    public void setPreview(String preview, String lang) {
        if (preview != null) {
            this.getPreviews().put(I18NHelper.checkLanguage(lang), preview);
        }
    }

    public String getPreview() {
        if (this.getPreview(null) != null) {
            return this.getPreview(null);
        }
        return "";
    }

    public String getPreview(String lang) {
        return this.getTranslation(this.getPreviews(), lang);
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        if (this.lang != null) {
            return this.lang;
        }
        return "";
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = this.getDate(creationDate);
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = this.getDate(creationDate);
    }

    public String getCreationDate() {
        if (this.creationDate != null) {
            return this.creationDate;
        }
        return this.getDate(new Date());
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public String getCreationUser() {
        if (this.creationUser != null) {
            return this.creationUser;
        }
        return "";
    }

    public void setStartDate(Date date) {
        this.startDate = this.getDate(date);
    }

    public void setStartDate(LocalDate date) {
        this.startDate = this.getDate(date);
    }

    public String getStartDate() {
        return Objects.requireNonNullElse(this.startDate, START_DATE_DEFAULT);
    }

    public void setEndDate(Date date) {
        this.endDate = this.getDate(date);
    }

    public void setEndDate(LocalDate date) {
        this.endDate = this.getDate(date);
    }

    public String getEndDate() {
        return Objects.requireNonNullElse(this.endDate, END_DATE_DEFAULT);
    }

    public boolean equals(Object o) {
        if (o instanceof IndexEntry) {
            IndexEntry e = (IndexEntry)o;
            return this.getPK().equals(e.getPK());
        }
        return false;
    }

    public int hashCode() {
        return this.getPK().hashCode();
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getThumbnailDirectory() {
        return this.thumbnailDirectory;
    }

    public void setThumbnailDirectory(String thumbnailDirectory) {
        this.thumbnailDirectory = thumbnailDirectory;
    }

    public String getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    public void setThumbnailMimeType(String thumbnailMimeType) {
        this.thumbnailMimeType = thumbnailMimeType;
    }

    private Map<String, String> getTitles() {
        if (this.titles == null) {
            this.titles = new HashMap<String, String>();
        }
        return this.titles;
    }

    private Map<String, String> getPreviews() {
        if (this.previews == null) {
            this.previews = new HashMap<String, String>();
        }
        return this.previews;
    }

    private Map<String, String> getAllKeywords() {
        if (this.keywordsI18N == null) {
            this.keywordsI18N = new HashMap<String, String>();
        }
        return this.keywordsI18N;
    }

    public Iterator<String> getLanguages() {
        return this.getTitles().keySet().iterator();
    }

    public boolean isIndexId() {
        return this.indexId;
    }

    public void setIndexId(boolean indexId) {
        this.indexId = indexId;
    }

    public String getLastModificationDate() {
        if (!StringUtil.isDefined((String)this.lastModificationDate)) {
            return this.getCreationDate();
        }
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = this.getDate(lastModificationDate);
    }

    public void setLastModificationDate(LocalDate lastModificationDate) {
        this.lastModificationDate = this.getDate(lastModificationDate);
    }

    public String getLastModificationUser() {
        if (!StringUtil.isDefined((String)this.lastModificationUser)) {
            return this.getCreationUser();
        }
        return this.lastModificationUser;
    }

    public void setLastModificationUser(String lastModificationUser) {
        this.lastModificationUser = lastModificationUser;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPK(IndexEntryKey pk) {
        this.pk = pk;
    }

    public boolean isLinkedObject() {
        return StringUtil.isDefined((String)this.pk.getLinkedObjectId());
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    private String getDate(Date date) {
        return this.getDate(DateUtil.toLocalDate((Date)date));
    }

    private String getDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return DateUtil.formatAsLuceneDate((LocalDate)date);
    }

    private String getTranslation(Map<String, String> translations, String lang) {
        String preview = translations.get(I18NHelper.checkLanguage(lang));
        if (!StringUtil.isDefined((String)preview)) {
            Set<String> languages = I18NHelper.getAllSupportedLanguages();
            for (String language : languages) {
                preview = translations.get(language);
                if (!StringUtil.isDefined((String)preview)) continue;
                return preview;
            }
        }
        return preview;
    }
}

