/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.publication.dao.DistributionTreeCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.ValidationStep;
import org.silverpeas.core.contribution.publication.social.SocialInformationPublication;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.util.Pair;

public interface PublicationService {
    public static PublicationService get() {
        return (PublicationService)ServiceProvider.getService(PublicationService.class, (Annotation[])new Annotation[0]);
    }

    public PublicationDetail getDetail(PublicationPK var1);

    public PublicationPK createPublication(PublicationDetail var1);

    public void movePublication(PublicationPK var1, NodePK var2, boolean var3);

    public void changePublicationOrder(PublicationPK var1, NodePK var2, int var3);

    public void deletePublication(PublicationPK var1);

    public void removePublication(PublicationPK var1);

    public void restorePublication(PublicationPK var1);

    public void setDetail(PublicationDetail var1);

    public void setDetail(PublicationDetail var1, boolean var2);

    public void setDetail(PublicationDetail var1, boolean var2, ResourceEvent.Type var3);

    public void addFather(PublicationPK var1, NodePK var2);

    public void removeFather(PublicationPK var1, NodePK var2);

    public void removeFathers(PublicationPK var1, Collection<String> var2);

    public void removeAllFathers(PublicationPK var1);

    public Collection<PublicationDetail> getOrphanPublications(String var1);

    @Deprecated
    public Collection<NodePK> getAllFatherPK(PublicationPK var1);

    public List<NodePK> getAllFatherPKInSamePublicationComponentInstance(PublicationPK var1);

    public Map<String, List<Location>> getAllLocationsByPublicationIds(Collection<String> var1);

    public List<Location> getAllLocations(PublicationPK var1);

    public List<Location> getLocationsInComponentInstance(PublicationPK var1, String var2);

    public Optional<Location> getMainLocation(PublicationPK var1);

    public List<Location> getAllAliases(PublicationPK var1);

    public Pair<Collection<Location>, Collection<Location>> setAliases(PublicationPK var1, List<Location> var2);

    public void addAliases(PublicationPK var1, List<Location> var2);

    public void removeAliases(PublicationPK var1, Collection<Location> var2);

    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK var1);

    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK var1, String var2);

    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK var1, String var2, boolean var3);

    public Collection<PublicationDetail> getVisiblePublicationsIn(NodePK var1);

    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK var1, String var2, boolean var3, String var4);

    public Collection<PublicationDetail> getDetailsNotInFatherPK(NodePK var1);

    public Collection<PublicationDetail> getDetailsNotInFatherPK(NodePK var1, String var2);

    public void deleteLink(String var1);

    public CompletePublication getCompletePublication(PublicationPK var1);

    public List<PublicationDetail> getPublications(Collection<PublicationPK> var1);

    public List<PublicationDetail> getByIds(Collection<String> var1);

    public SilverpeasList<PublicationDetail> getPublicationsByCriteria(PublicationCriteria var1);

    public SilverpeasList<PublicationDetail> getAuthorizedPublicationsForUserByCriteria(String var1, PublicationCriteria var2);

    public int getNbPubByFatherPath(NodePK var1, String var2);

    public Map<String, Integer> getDistributionTree(DistributionTreeCriteria var1);

    public Collection<PublicationDetail> getDetailsByFatherIds(List<String> var1, String var2, boolean var3);

    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatus(List<String> var1, String var2, String var3, String var4);

    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatusList(List<String> var1, String var2, String var3, List<String> var4);

    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatusList(List<String> var1, String var2, String var3, List<String> var4, boolean var5);

    public Collection<PublicationPK> getPubPKsInFatherPK(NodePK var1);

    public void createIndex(PublicationPK var1);

    public void createIndex(PublicationDetail var1);

    public void deleteIndex(PublicationPK var1);

    public List<PublicationDetail> getMinimalDataByIds(Collection<PublicationPK> var1);

    public Collection<PublicationDetail> getAllPublications(String var1);

    public Collection<PublicationDetail> getAllPublications(String var1, String var2);

    public PublicationDetail getDetailByName(PublicationPK var1, String var2);

    public PublicationDetail getDetailByNameAndNodeId(PublicationPK var1, String var2, int var3);

    public Collection<PublicationDetail> getDetailBetweenDate(String var1, String var2, String var3);

    public List<ValidationStep> getValidationSteps(PublicationPK var1);

    public ValidationStep getValidationStepByUser(PublicationPK var1, String var2);

    public void addValidationStep(ValidationStep var1);

    public void removeValidationSteps(PublicationPK var1);

    public void changePublicationsOrder(List<String> var1, NodePK var2);

    public void resetPublicationsOrder(NodePK var1);

    public Collection<Coordinate> getCoordinates(String var1, String var2);

    public void addLinks(PublicationPK var1, List<ResourceReference> var2);

    public List<SocialInformationPublication> getAllPublicationsWithStatusbyUserid(String var1, Date var2, Date var3);

    public List<SocialInformationPublication> getSocialInformationsListOfMyContacts(List<String> var1, List<String> var2, Date var3, Date var4);

    public Collection<PublicationDetail> getDraftsByUser(String var1);

    public List<PublicationDetail> removeUserFromTargetValidators(String var1);
}

