/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractGlobalSilverContentProcessor;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContent;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailReference;
import org.silverpeas.core.io.media.image.thumbnail.service.ThumbnailService;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.util.StringUtil;

public abstract class PublicationGlobalSilverpeasContentProcessor
extends AbstractGlobalSilverContentProcessor {
    @Inject
    private ThumbnailService thumbnailService;

    @Override
    public Stream<GlobalSilverContent> asGlobalSilverContent(List<SilverContentInterface> silverContents) {
        Map<String, PublicationDetail> indexedPublications = silverContents.stream().map(c -> (PublicationDetail)((AbstractSilverpeasContentManager.ContributionWrapper)c).getWrappedInstance()).collect(Collectors.toMap(PublicationDetail::getId, p -> p));
        Set<ThumbnailReference> thumbnailReferences = indexedPublications.values().stream().map(p -> new ThumbnailReference(p.getId(), p.getComponentInstanceId(), 1)).collect(Collectors.toSet());
        Map<String, ThumbnailDetail> thumbnailsByPubId = this.thumbnailService.getByReference(thumbnailReferences).stream().collect(Collectors.toMap(t -> t.getReference().getId(), t -> t));
        return super.asGlobalSilverContent(silverContents).peek(g -> {
            String pubId = g.getId();
            g.setType("Publication");
            ThumbnailDetail thumbnail = (ThumbnailDetail)thumbnailsByPubId.get(pubId);
            if (thumbnail != null) {
                PublicationDetail pub = (PublicationDetail)indexedPublications.get(pubId);
                pub.setThumbnail(thumbnail);
                if (StringUtil.isDefined((String)pub.getImage())) {
                    String imageURL = FileServerUtils.getUrl(pub.getPK().getComponentName(), "vignette", pub.getImage(), pub.getImageMimeType(), "images");
                    g.setThumbnailURL(imageURL);
                }
            }
        });
    }
}

