/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.converter.openoffice;

import java.io.File;
import javax.inject.Named;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.ToHTMLConverter;
import org.silverpeas.core.contribution.converter.openoffice.OpenOfficeConverter;
import org.silverpeas.core.util.file.FileUtil;

@Service
@Named(value="toHTMLConverter")
public class OpenOfficeToHTMLConverter
extends OpenOfficeConverter
implements ToHTMLConverter {
    @Override
    public DocumentFormat[] getSupportedFormats() {
        return new DocumentFormat[]{DocumentFormat.html};
    }

    @Override
    public boolean isDocumentSupported(File document) {
        return FileUtil.isOpenOfficeCompatible(document.getName()) || "application/rtf".equals(FileUtil.getMimeType(document.getPath()));
    }
}

