/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.converter.openoffice;

import java.util.stream.Stream;
import javax.inject.Singleton;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.local.office.LocalOfficeManager;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
public class OpenOfficeService
implements Initialization {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.converter.openoffice");
    private static final String OPENOFFICE_PORT = "openoffice.port";
    private static final String OPENOFFICE_HOME = "openoffice.home";
    private static final String OPENOFFICE_QUEUE_TIMEOUT = "openoffice.task.queueTimeout";
    private static final String OPENOFFICE_EXECUTION_TIMEOUT = "openoffice.task.executionTimeout";
    private OfficeManager officeManager;

    public void init() {
        String home = settings.getString(OPENOFFICE_HOME, null);
        String ports = settings.getString(OPENOFFICE_PORT, "8100");
        long taskQueueTimeout = settings.getLong(OPENOFFICE_QUEUE_TIMEOUT, 30000L);
        long taskExecutionTimeout = settings.getLong(OPENOFFICE_EXECUTION_TIMEOUT, 120000L);
        int[] portNumbers = Stream.of(ports.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
        LocalOfficeManager.Builder config = (LocalOfficeManager.Builder)((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().install()).officeHome(home).portNumbers(portNumbers).taskExecutionTimeout(Long.valueOf(taskExecutionTimeout))).taskQueueTimeout(Long.valueOf(taskQueueTimeout));
        this.startOfficeManager(config);
    }

    private void startOfficeManager(LocalOfficeManager.Builder builder) {
        this.officeManager = builder.build();
        try {
            this.officeManager.start();
        }
        catch (OfficeException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void release() {
        OfficeUtils.stopQuietly((OfficeManager)this.officeManager);
    }

    public OfficeManager getOfficeManager() {
        return this.officeManager;
    }
}

