/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class SequenceField
extends TextField {
    private static final long serialVersionUID = -6526406111012877271L;
    public static final String TYPE = "sequence";
    private static final String VALUES_QUERY = "select distinct(f.fieldValue) from sb_formtemplate_template t, sb_formtemplate_record r, sb_formtemplate_textfield f where t.templateId = r.templateId and r.recordId = f.recordId and f.fieldName = ? and t.externalId = ?";
    private static final String GLOBAL_VALUES_QUERY = "select distinct(f.fieldValue) from sb_formtemplate_template t, sb_formtemplate_record r, sb_formtemplate_textfield f where t.templateId = r.templateId and r.recordId = f.recordId and f.fieldName = ? and t.externalId like ?";
    private static final int NUMBER_ERROR = -1;
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public String getNextValue(String fieldName, String templateName, String componentId, int minLength, int startValue, boolean reuseAvailableValues, boolean global) {
        int newValue;
        List<Integer> values = this.getValues(fieldName, templateName, componentId, global);
        if (values.isEmpty()) {
            newValue = startValue;
        } else if (reuseAvailableValues) {
            newValue = startValue;
            while (values.contains(newValue)) {
                ++newValue;
            }
        } else {
            newValue = values.get(values.size() - 1) + 1;
        }
        return SequenceField.numberToString(newValue, minLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getValues(String fieldName, String templateName, String componentId, boolean global) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try (Connection connection = DBUtil.openConnection();){
            statement = global ? connection.prepareStatement(GLOBAL_VALUES_QUERY) : connection.prepareStatement(VALUES_QUERY);
            statement.setString(1, fieldName);
            if (global) {
                statement.setString(2, "%:" + templateName);
            } else {
                statement.setString(2, componentId + ":" + templateName);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                int currentValue = SequenceField.numberToInt(rs.getString(1));
                if (currentValue == -1) continue;
                values.add(currentValue);
            }
        }
        catch (Exception e) {
            try {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
            DBUtil.close(rs, (Statement)statement);
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        Collections.sort(values);
        return values;
    }

    private static String numberToString(int number, int minLength) {
        StringBuilder result = new StringBuilder();
        result.append(number);
        while (result.length() < minLength) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    private static int numberToInt(String number) {
        String currentNumber = number;
        if (currentNumber != null && currentNumber.length() > 0) {
            while (currentNumber.startsWith("0")) {
                currentNumber = currentNumber.substring(1);
            }
            try {
                return Integer.parseInt(currentNumber);
            }
            catch (NumberFormatException e) {
                SilverLogger.getLogger(SequenceField.class).error((Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

