/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.util.ArrayList;
import java.util.List;
import org.apache.ecs.html.A;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationsPickerField
extends AbstractField {
    private static final long serialVersionUID = -4982574221213514901L;
    public static final String TYPE = "publicationsPicker";
    private int nbPublications = 0;
    private String rawResourceReferences = null;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String getRawResourceReferences() {
        return this.rawResourceReferences;
    }

    public void setRawResourceReferences(String rawResourceReferences) {
        StringBuilder verifiedResources = new StringBuilder();
        if (StringUtil.isDefined((String)rawResourceReferences)) {
            String[] array;
            for (String rawResourceReference : array = rawResourceReferences.split(",")) {
                ContributionIdentifier id = ContributionIdentifier.decode((String)rawResourceReference);
                PublicationDetail publi = PublicationService.get().getDetail(new PublicationPK(id.getLocalId(), id.getComponentInstanceId()));
                if (publi == null) continue;
                if (verifiedResources.length() > 0) {
                    verifiedResources.append(",");
                }
                verifiedResources.append(rawResourceReference);
            }
        }
        this.rawResourceReferences = verifiedResources.toString();
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        return this.getValue(I18NHelper.DEFAULT_LANGUAGE);
    }

    @Override
    public String getValue(String language) {
        return this.getListOfPublications(true, language);
    }

    public String getValueAsText(String language) {
        return this.getListOfPublications(false, language);
    }

    @Override
    public void setValue(String value) throws FormException {
        this.setRawResourceReferences(value);
    }

    @Override
    public void setValue(String value, String language) throws FormException {
        this.setValue(value);
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        return this.getResourceReferences();
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof List) {
            StringBuilder resRef = new StringBuilder();
            List list = (List)value;
            for (ContributionIdentifier identifier : list) {
                if (resRef.length() > 0) {
                    resRef.append(",");
                }
                resRef.append(identifier.asString());
            }
            this.setRawResourceReferences(resRef.toString());
        } else if (value == null) {
            this.setRawResourceReferences(null);
        } else {
            throw new FormException("Incorrect field value type. Expected a list of contribution identifiers", new String[0]);
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof UserDetail && !this.isReadOnly();
    }

    @Override
    public String getStringValue() {
        return this.getRawResourceReferences();
    }

    @Override
    public void setStringValue(String value) {
        this.setRawResourceReferences(value);
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return CollectionUtil.isEmpty(this.getResourceReferences());
    }

    @Override
    public void setNull() throws FormException {
        this.setRawResourceReferences(null);
    }

    public int getNbPublications() {
        return this.nbPublications;
    }

    public boolean equals(Object o) {
        String s = this.getRawResourceReferences();
        if (o instanceof PublicationsPickerField) {
            String t = ((PublicationsPickerField)o).getRawResourceReferences();
            return s == null || s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Field o) {
        String s = this.getValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof PublicationsPickerField) {
            String t = o.getValue();
            if (t == null) {
                t = "";
            }
            if (s.equals(t)) {
                s = this.getRawResourceReferences();
                if (s == null) {
                    s = "";
                }
                if ((t = ((PublicationsPickerField)o).getRawResourceReferences()) == null) {
                    t = "";
                }
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getRawResourceReferences();
        return s.hashCode();
    }

    private List<ContributionIdentifier> getResourceReferences() {
        ArrayList<ContributionIdentifier> resourceReferences = new ArrayList<ContributionIdentifier>();
        if (StringUtil.isDefined((String)this.getRawResourceReferences())) {
            String[] array;
            for (String rawResourceReference : array = this.getRawResourceReferences().split(",")) {
                resourceReferences.add(ContributionIdentifier.decode((String)rawResourceReference));
            }
        }
        return resourceReferences;
    }

    private String getListOfPublications(boolean useLink, String language) {
        List<ContributionIdentifier> refs = this.getResourceReferences();
        if (CollectionUtil.isEmpty(refs)) {
            return "";
        }
        StringBuilder displayedValue = new StringBuilder();
        for (ContributionIdentifier ref : refs) {
            PublicationDetail publi = PublicationService.get().getDetail(new PublicationPK(ref.getLocalId(), ref.getComponentInstanceId()));
            if (publi == null) continue;
            if (displayedValue.length() > 0) {
                displayedValue.append("\n");
            }
            String pubName = publi.getName(language);
            if (useLink) {
                A a2 = new A(publi.getPermalink(), pubName);
                a2.setClass("sp-permalink");
                displayedValue.append(a2);
            } else {
                displayedValue.append(pubName);
            }
            ++this.nbPublications;
        }
        return displayedValue.toString();
    }
}

