/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.List;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractTextFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public class UrlFieldDisplayer
extends AbstractTextFieldDisplayer {
    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        Object html2 = "";
        AbstractTextFieldDisplayer.FieldProperties fieldProps = this.getFieldProperties(template, field, pageContext);
        Object value = fieldProps.getValue();
        String fieldName = fieldProps.getFieldName();
        if (template.isReadOnly() && !template.isHidden()) {
            if (StringUtil.isDefined((String)value)) {
                if (!(((String)value).startsWith("http") || ((String)value).startsWith("ftp:") || ((String)value).startsWith("/"))) {
                    value = "https://" + (String)value;
                }
                html2 = "<a target=\"_blank\" href=\"" + (String)value + "\">" + WebEncodeHelper.javaStringToHtmlString((String)value) + "</a>";
            }
        } else {
            String paramSuggestions = fieldProps.getParameters().getOrDefault("suggestions", "false");
            boolean useSuggestions = Boolean.parseBoolean(paramSuggestions);
            List<String> suggestions = UrlFieldDisplayer.getSuggestions((TextFieldImpl)field, template, pageContext, fieldName, useSuggestions);
            input inputField = UrlFieldDisplayer.makeTextInput(fieldProps, null);
            img image = UrlFieldDisplayer.getMandatoryIcon(template, pageContext);
            if (suggestions != null && !suggestions.isEmpty()) {
                UrlFieldDisplayer.printSuggestions(out, fieldName, suggestions, inputField, image);
            } else {
                this.printFields(out, inputField, image);
            }
        }
        out.println((String)html2);
    }

    private void printFields(PrintWriter out, input inputField, img image) {
        Printable elt = this.setImage(inputField, image);
        out.println(elt);
    }

    private static void printSuggestions(PrintWriter out, String fieldName, List<String> suggestions, input inputField, img image) {
        TextFieldImpl.printSuggestionsIncludes(fieldName, out);
        out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
        out.println(inputField);
        out.println("<div id=\"container" + fieldName + "\"/>\n");
        out.println("</div>\n");
        if (image != null) {
            image.setStyle("position:absolute;left:16em;top:5px");
            out.println(image);
        }
        TextFieldImpl.printSuggestionsScripts(fieldName, suggestions, out);
    }

    private static List<String> getSuggestions(TextFieldImpl field, FieldTemplate template, PagesContext pageContext, String fieldName, boolean useSuggestions) {
        List<String> suggestions = null;
        if (useSuggestions) {
            suggestions = field.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
        }
        return suggestions;
    }
}

