/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.input;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.CheckBoxDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.util.DateUtil;

public class TimeFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String label = Encode.forHtml((String)template.getLabel(language));
        out.println("var " + template.getFieldName() + "Empty = isWhitespace(stripInitialWhitespace(field.value));");
        TimeFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        out.println(" if (!" + template.getFieldName() + "Empty) {");
        out.println("var reg=new RegExp(\"^([01][0-9]|2[0-3]):([0-5][0-9])$\",\"g\");");
        out.println("if (!reg.test(field.value)) {");
        out.println("\t\terrorMsg+=\"  - '" + label + "' " + Util.getString("GML.MustContainsCorrectHour", language) + "\\n \";");
        out.println("\t\terrorNb++;");
        out.println("}");
        out.println("}");
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String html2;
        if (field == null) {
            return;
        }
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String value = this.getValue(field, pageContext, parameters);
        if (template.isReadOnly() && !template.isHidden()) {
            html2 = value;
        } else {
            html2 = "";
            input inputField = new input();
            inputField.setName(template.getFieldName());
            inputField.setID(template.getFieldName());
            inputField.setValue(Encode.forHtml((String)value));
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength("5");
            inputField.setSize("10");
            Printable elt = TimeFieldDisplayer.initInputField(template, inputField, pageContext);
            out.println(elt);
        }
        out.println(html2);
    }

    private String getValue(TextField field, PagesContext pageContext, Map<String, String> parameters) {
        String value;
        String defaultParam = parameters.getOrDefault("default", "");
        String defaultValue = "";
        if ((pageContext.isCreation() || pageContext.isDesignMode()) && !pageContext.isIgnoreDefaultValues() && !defaultParam.isEmpty()) {
            defaultValue = "now".equalsIgnoreCase(defaultParam) ? DateUtil.formatTime((Date)new Date()) : defaultParam;
        }
        String string = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        return value;
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        CheckBoxDisplayer.setFieldValue(newValue, field, pagesContext);
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

