/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.webdav;

import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.attachment.notification.AttachmentEvent;
import org.silverpeas.core.contribution.attachment.notification.AttachmentRef;
import org.silverpeas.core.contribution.attachment.webdav.WebdavWbeFile;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;

@Bean
public class AttachmentWebdavListener
extends CDIResourceEventListener<AttachmentEvent> {
    public void onUpdate(AttachmentEvent event) {
        AttachmentRef attachment = (AttachmentRef)event.getTransition().getBefore();
        this.release(attachment);
    }

    public void onUnlock(AttachmentEvent event) {
        this.onUpdate(event);
    }

    public void onRemoving(AttachmentEvent event) {
        this.onUpdate(event);
    }

    public void onDeletion(AttachmentEvent event) {
        this.onUpdate(event);
    }

    private void release(AttachmentRef attachment) {
        WbeHostManager.get().revokeFile((WbeFile)new WebdavWbeFile(attachment.getId(), null));
    }
}

