/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.permalinks;

import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.permalinks.PermalinkCompatibilityService;
import org.silverpeas.core.contribution.attachment.permalinks.model.DocumentPermalink;
import org.silverpeas.core.contribution.attachment.permalinks.model.VersionPermalink;
import org.silverpeas.core.contribution.attachment.permalinks.repository.DocumentPermalinkRepository;
import org.silverpeas.core.contribution.attachment.permalinks.repository.VersionPermalinkRepository;

@Default
@Service
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class PermalinkCompatibilityServiceImpl
implements PermalinkCompatibilityService {
    @Inject
    private AttachmentService service;
    @Inject
    private DocumentPermalinkRepository docManager;
    @Inject
    private VersionPermalinkRepository versionManager;

    @Override
    public SimpleDocument findDocumentVersionByOldId(int oldId) {
        VersionPermalink link = (VersionPermalink)this.versionManager.getById(Integer.toString(oldId));
        if (link != null) {
            SimpleDocumentPK pk = new SimpleDocumentPK(link.getUuid(), "");
            return this.service.searchDocumentById(pk, null);
        }
        return null;
    }

    @Override
    public SimpleDocument findVersionnedDocumentByOldId(int oldId) {
        DocumentPermalink link = (DocumentPermalink)this.docManager.getById(Integer.toString(oldId));
        if (link != null) {
            SimpleDocumentPK pk = new SimpleDocumentPK(link.getUuid(), "");
            return this.service.searchDocumentById(pk, null);
        }
        return null;
    }
}

