/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.util.URLUtil;

public class SimpleDocumentVersion
extends SimpleDocument {
    private static final long serialVersionUID = 6383649345169447613L;
    private SimpleDocumentVersion previousVersion;
    private SimpleDocumentPK realVersionPk;
    private String realVersionForeignId;

    public SimpleDocumentVersion(SimpleDocument documentVersion, HistorisedDocument masterVersion) {
        super(documentVersion);
        this.setVersionMaster(masterVersion);
    }

    @Override
    public HistorisedDocument getVersionMaster() {
        return (HistorisedDocument)super.getVersionMaster();
    }

    @Override
    public void setVersionMaster(SimpleDocument versionMaster) {
        if (!(versionMaster instanceof HistorisedDocument)) {
            throw new IllegalArgumentException("The master version must be an historized one ...");
        }
        super.setVersionMaster(versionMaster);
        if (this.realVersionPk == null) {
            this.realVersionPk = this.getPk().copy();
            this.realVersionForeignId = this.getForeignId();
        }
        this.getPk().setComponentName(this.getVersionMaster().getInstanceId());
        this.getPk().setOldSilverpeasId(this.getVersionMaster().getOldSilverpeasId());
        this.setForeignId(this.getVersionMaster().getForeignId());
        this.setNodeName(this.getVersionMaster().getNodeName());
    }

    public SimpleDocumentVersion getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(SimpleDocumentVersion previousVersion) {
        this.previousVersion = previousVersion;
    }

    public SimpleDocumentPK getRealVersionPk() {
        if (this.realVersionPk == null) {
            return this.getPk();
        }
        return this.realVersionPk;
    }

    public String getRealVersionForeignId() {
        if (this.realVersionForeignId == null) {
            return this.getForeignId();
        }
        return this.realVersionForeignId;
    }

    @Override
    public boolean isVersioned() {
        return true;
    }

    @Override
    public SimpleDocument getLastPublicVersion() {
        for (SimpleDocumentVersion current = this; current != null; current = current.getPreviousVersion()) {
            if (!current.isPublic()) continue;
            return current;
        }
        return null;
    }

    @Override
    public String getWebdavUrl() {
        return null;
    }

    @Override
    public String getOnlineURL() {
        return null;
    }

    @Override
    public String getAttachmentURL() {
        return super.getAttachmentURL();
    }

    @Override
    public String getUniversalURL() {
        return URLUtil.getSimpleURL(9, this.getId()) + "?ContentLanguage=" + this.getLanguage();
    }
}

