/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.ContributionLocator;
import org.silverpeas.core.contribution.ContributionLocatorByLocalIdAndType;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class DefaultContributionLocator
implements ContributionLocator {
    private final Map<String, List<Class<? extends ContributionLocatorByLocalIdAndType>>> potentialLocatorsByType = new HashMap<String, List<Class<? extends ContributionLocatorByLocalIdAndType>>>();

    public Optional<ContributionIdentifier> locateByLocalIdAndType(String localId, String type) {
        List<Class<? extends ContributionLocatorByLocalIdAndType>> potentialLocators = this.getPotentialLocators(type);
        for (Class<? extends ContributionLocatorByLocalIdAndType> locatorClass : potentialLocators) {
            ContributionLocatorByLocalIdAndType locator = (ContributionLocatorByLocalIdAndType)ServiceProvider.getService(locatorClass, (Annotation[])new Annotation[0]);
            Optional contributionIdentifier = locator.getContributionIdentifierFromLocalIdAndType(localId, type);
            if (!contributionIdentifier.isPresent()) continue;
            return contributionIdentifier;
        }
        return this.notLocated(localId, type);
    }

    private List<Class<? extends ContributionLocatorByLocalIdAndType>> getPotentialLocators(String type) {
        List<Class<? extends ContributionLocatorByLocalIdAndType>> potentialLocators = this.potentialLocatorsByType.get(type);
        if (potentialLocators == null) {
            potentialLocators = new ArrayList<Class<? extends ContributionLocatorByLocalIdAndType>>();
            Set locators = ServiceProvider.getAllServices(ContributionLocatorByLocalIdAndType.class, (Annotation[])new Annotation[0]);
            for (ContributionLocatorByLocalIdAndType locator : locators) {
                if (!locator.isContributionLocatorOfType(type)) continue;
                potentialLocators.add(locator.getClass());
            }
            this.potentialLocatorsByType.put(type, potentialLocators);
        }
        return potentialLocators;
    }

    private Optional<ContributionIdentifier> notLocated(String localId, String type) {
        SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)"ContributionIdentifier", (Object)(localId + "[" + type + "]")), new Object[0]);
        return Optional.empty();
    }
}

