/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AbstractNotifier;
import org.silverpeas.core.calendar.notification.AttendeeLifeCycleEventNotifier;
import org.silverpeas.core.calendar.notification.AttendeeNotificationBuilder;
import org.silverpeas.core.calendar.notification.CalendarEventOccurrenceLifeCycleEvent;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.calendar.notification.LifeCycleEventSubType;
import org.silverpeas.core.calendar.notification.SubscriberNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

@Bean
public class CalendarEventOccurrenceNotifier
extends AbstractNotifier<CalendarEventOccurrenceLifeCycleEvent> {
    public void onDeletion(CalendarEventOccurrenceLifeCycleEvent event) {
        CalendarEventOccurrence deleted = (CalendarEventOccurrence)event.getTransition().getBefore();
        CalendarOperation operation = CalendarOperation.EVENT_DELETION;
        if (event.getSubtype() == LifeCycleEventSubType.SINCE) {
            operation = CalendarOperation.SINCE_EVENT_DELETION;
        }
        User sender = User.getCurrentRequester();
        AttendeeNotificationBuilder attendeeNotificationBuilder = new AttendeeNotificationBuilder((PlannedOnCalendar)deleted, NotifAction.DELETE).immediately().from(sender).to(this.concernedAttendeesIn(deleted.asCalendarComponent())).about(operation);
        attendeeNotificationBuilder.build().send();
        new SubscriberNotificationBuilder(deleted, NotifAction.DELETE).from(sender).about(operation).excludingUsersIds(attendeeNotificationBuilder.getUserIdsToNotify()).build().send();
    }

    public void onUpdate(CalendarEventOccurrenceLifeCycleEvent event) {
        CalendarEventOccurrence before = (CalendarEventOccurrence)event.getTransition().getBefore();
        CalendarEventOccurrence after = (CalendarEventOccurrence)event.getTransition().getAfter();
        if (after.isModifiedSince(before)) {
            CalendarOperation operation = CalendarOperation.EVENT_UPDATE;
            if (event.getSubtype() == LifeCycleEventSubType.SINCE) {
                operation = CalendarOperation.SINCE_EVENT_UPDATE;
            }
            User sender = User.getCurrentRequester();
            AttendeeNotificationBuilder attendeeNotificationBuilder = new AttendeeNotificationBuilder((PlannedOnCalendar)after, NotifAction.UPDATE).immediately().from(sender).to(this.concernedAttendeesIn(before.asCalendarComponent())).about(operation);
            attendeeNotificationBuilder.build().send();
            new SubscriberNotificationBuilder(after, NotifAction.UPDATE).from(sender).about(operation).excludingUsersIds(attendeeNotificationBuilder.getUserIdsToNotify()).build().send();
        }
        if (after.getAttendees().isNotSameAs(before.getAttendees())) {
            AttendeeLifeCycleEventNotifier.notifyAttendees((LifeCycleEventSubType)event.getSubtype(), (PlannedOnCalendar)after, (AttendeeSet)before.getAttendees(), (AttendeeSet)after.getAttendees());
        }
    }
}

