/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.ExternalAttendee;
import org.silverpeas.core.calendar.InternalAttendee;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AbstractCalendarEventUserNotificationBuilder;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.notification.user.RemoveSenderRecipientBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;

class AttendeeNotificationBuilder
extends AbstractCalendarEventUserNotificationBuilder
implements RemoveSenderRecipientBehavior {
    private List<Attendee> recipients;
    private List<Attendee> attendees;

    AttendeeNotificationBuilder(PlannedOnCalendar calendarComponent, NotifAction action) {
        super(calendarComponent, action);
    }

    @Override
    public AttendeeNotificationBuilder about(CalendarOperation operation) {
        return (AttendeeNotificationBuilder)super.about(operation);
    }

    public AttendeeNotificationBuilder about(CalendarOperation operation, List<Attendee> attendees) {
        this.about(operation);
        this.attendees = attendees;
        return this;
    }

    public AttendeeNotificationBuilder about(CalendarOperation operation, Attendee ... attendees) {
        return this.about(operation, Arrays.asList(attendees));
    }

    @Override
    public AttendeeNotificationBuilder from(User sender) {
        return (AttendeeNotificationBuilder)super.from(sender);
    }

    @Override
    public AttendeeNotificationBuilder immediately() {
        return (AttendeeNotificationBuilder)super.immediately();
    }

    public AttendeeNotificationBuilder to(List<Attendee> attendees) {
        this.recipients = attendees;
        return this;
    }

    public AttendeeNotificationBuilder to(Attendee attendee) {
        this.recipients = Collections.singletonList(attendee);
        return this;
    }

    @Override
    protected String getBundleSubjectKey() {
        if (this.getOperation() == CalendarOperation.NONE) {
            return "subject.default";
        }
        if (this.getOperation() == CalendarOperation.EVENT_UPDATE || this.getOperation() == CalendarOperation.SINCE_EVENT_UPDATE) {
            return "subject.eventUpdate";
        }
        return "subject.attendance";
    }

    @Override
    protected void performTemplateData(LocalizedContribution contribution, SilverpeasTemplate template) {
        super.performTemplateData(contribution, template);
        if (this.attendees != null) {
            String language = contribution.getLanguage();
            template.setAttribute("attendees", this.attendees.stream().map(Attendee::getFullName).collect(Collectors.toList()));
            if (CalendarOperation.ATTENDEE_PARTICIPATION == this.getOperation() || CalendarOperation.SINCE_ATTENDEE_PARTICIPATION == this.getOperation()) {
                Optional<Attendee> attendee = this.attendees.stream().filter(a -> a.getId().equals(this.getSender())).findFirst();
                attendee.ifPresent(a -> {
                    String bundleKey = "event.attendee.participation." + a.getParticipationStatus().name().toLowerCase();
                    template.setAttribute("participation", (Object)this.getBundle(language).getString(bundleKey));
                });
            }
        }
    }

    @Override
    public Collection<String> getUserIdsToNotify() {
        return this.recipients.stream().filter(InternalAttendee.class::isInstance).map(Attendee::getId).collect(Collectors.toSet());
    }

    @Override
    protected Collection<String> getExternalAddressesToNotify() {
        return this.recipients.stream().filter(ExternalAttendee.class::isInstance).map(Attendee::getId).collect(Collectors.toSet());
    }

    @Override
    protected boolean isUserCanBeNotified(String userId) {
        if (PersonalComponentInstance.from(this.getComponentInstanceId()).isPresent()) {
            return true;
        }
        return super.isUserCanBeNotified(userId);
    }
}

