/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.SearchCriteria;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractSearchCriteria
implements SearchCriteria {
    private static final String USER_STATES_TO_EXCLUDE = "userStatesToExclude";
    private static final String INCLUDE_REMOVED_USERS = "includeRemovedUsers";
    private static final String ROLE_NAMES = "roleIds";
    private static final String MATCHING_ALL_ROLE_NAMES = "matchingAllRoleNames";
    protected Map<String, Object> criteria = new HashMap<String, Object>();

    @Override
    public SearchCriteria onUserStatesToExclude(UserState ... userStates) {
        if (ArrayUtil.isNotEmpty(userStates)) {
            this.criteria.put(USER_STATES_TO_EXCLUDE, userStates);
        }
        return this.adjustUserStatesToExclude();
    }

    @Override
    public SearchCriteria includeRemovedUsers() {
        this.criteria.put(INCLUDE_REMOVED_USERS, true);
        return this.adjustUserStatesToExclude();
    }

    @Override
    public SearchCriteria onRoleNames(String ... roleIds) {
        if (ArrayUtils.isNotEmpty((Object[])roleIds)) {
            this.criteria.put(ROLE_NAMES, Arrays.stream(roleIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public SearchCriteria matchingAllRoleNames() {
        this.criteria.put(MATCHING_ALL_ROLE_NAMES, true);
        return this;
    }

    private <T extends SearchCriteria> T adjustUserStatesToExclude() {
        if (this.isCriterionOnUserStatesToExcludeSet() && this.mustIncludeRemovedUsers()) {
            UserState[] statedToExclude = (UserState[])Stream.of(this.getCriterionOnUserStatesToExclude()).filter(Predicate.not(arg_0 -> UserState.REMOVED.equals(arg_0))).toArray(UserState[]::new);
            if (statedToExclude.length > 0) {
                this.criteria.put(USER_STATES_TO_EXCLUDE, statedToExclude);
            } else {
                this.criteria.remove(USER_STATES_TO_EXCLUDE);
            }
        }
        return (T)this;
    }

    public boolean isCriterionOnUserStatesToExcludeSet() {
        return this.criteria.containsKey(USER_STATES_TO_EXCLUDE);
    }

    public boolean isCriterionOnRoleNamesSet() {
        return this.criteria.containsKey(ROLE_NAMES);
    }

    public UserState[] getCriterionOnUserStatesToExclude() {
        return (UserState[])this.criteria.get(USER_STATES_TO_EXCLUDE);
    }

    public boolean mustIncludeRemovedUsers() {
        return Boolean.TRUE.equals(this.criteria.get(INCLUDE_REMOVED_USERS));
    }

    public String[] getCriterionOnRoleNames() {
        return (String[])this.criteria.get(ROLE_NAMES);
    }

    public boolean mustMatchAllRoles() {
        return this.isCriterionOnRoleNamesSet() && this.getCriterionOnRoleNames().length > 1 && Boolean.TRUE.equals(this.criteria.get(MATCHING_ALL_ROLE_NAMES));
    }

    @Override
    public void clear() {
        this.criteria.clear();
    }
}

