/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.silverpeas.core.admin.service.RemovedSpaceAndComponentInstanceChecker;

public class UserSpaceAvailabilityChecker {
    private final String userId;
    private final Set<String> userAllowedComponentIds;
    private final Function<String, Integer> toIntSpaceId;
    private final BiPredicate<Set<String>, Integer> isSpaceContainsOneComponent;
    private final RemovedSpaceAndComponentInstanceChecker removedChecker;

    UserSpaceAvailabilityChecker(String userId) {
        this(userId, Collections.emptyList(), null, null);
    }

    UserSpaceAvailabilityChecker(String userId, Collection<String> userAllowedComponentIds, Function<String, Integer> toIntSpaceId, BiPredicate<Set<String>, Integer> isSpaceContainsOneComponent) {
        this(userId, userAllowedComponentIds, toIntSpaceId, isSpaceContainsOneComponent, RemovedSpaceAndComponentInstanceChecker.create().resetWithCacheSizeOf(1));
    }

    UserSpaceAvailabilityChecker(String userId, Collection<String> userAllowedComponentIds, Function<String, Integer> toIntSpaceId, BiPredicate<Set<String>, Integer> isSpaceContainsOneComponent, RemovedSpaceAndComponentInstanceChecker removedChecker) {
        this.userId = userId;
        this.userAllowedComponentIds = new HashSet<String>(userAllowedComponentIds);
        this.toIntSpaceId = toIntSpaceId;
        this.isSpaceContainsOneComponent = isSpaceContainsOneComponent;
        this.removedChecker = removedChecker;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAvailable(String spaceId) {
        return !this.userAllowedComponentIds.isEmpty() && !this.removedChecker.isRemovedSpaceById(spaceId) && this.isSpaceContainsOneComponent.test(this.userAllowedComponentIds, this.toIntSpaceId.apply(spaceId));
    }
}

