/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.quota;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.domain.DomainDriverManager;
import org.silverpeas.core.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.service.AbstractQuotaService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
public class UserDomainQuotaService
extends AbstractQuotaService<UserDomainQuotaKey> {
    @Inject
    private DomainDriverManager domainDriverManager;
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.jobDomainPeas.settings.jobDomainPeasSettings");

    @Override
    @Transactional
    public long getCurrentCount(UserDomainQuotaKey key) throws QuotaException {
        try {
            return this.domainDriverManager.getAllUsers(key.getResourceId()).length;
        }
        catch (Exception e) {
            throw new QuotaException(null, e);
        }
    }

    @Override
    protected boolean isActivated() {
        return settings.getBoolean("quota.domain.users.activated", false);
    }
}

