/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSettings;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSynchroCache;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractLDAPGroup {
    private static final String LDAPGROUP_GET_GROUPS = "AbstractLDAPGroup.getGroups()";
    private static final String LDAPGROUP_TRANSLATE_GROUPS = "AbstractLDAPGroup.translateGroups()";
    LDAPSettings driverSettings = null;
    LDAPSynchroCache synchroCache = null;
    private StringBuilder synchroReport = null;
    boolean synchroInProcess = false;

    public void init(LDAPSettings driverSettings, LDAPSynchroCache synchroCache) {
        this.driverSettings = driverSettings;
        this.synchroCache = synchroCache;
    }

    AbstractLDAPGroup append(CharSequence message) {
        this.synchroReport.append(message);
        return this;
    }

    public void beginSynchronization() {
        this.synchroReport = new StringBuilder();
        this.synchroInProcess = true;
    }

    public String endSynchronization() {
        this.synchroInProcess = false;
        return this.synchroReport.toString();
    }

    public GroupDetail[] getAllGroups(String lds, String extraFilter) throws AdminException {
        HashMap<String, GroupDetail> groupsDone = new HashMap<String, GroupDetail>();
        GroupDetail[] groupsVector = this.getGroups(lds, null, extraFilter);
        ArrayList<GroupDetail> groupsCurrent = new ArrayList<GroupDetail>(Arrays.asList(groupsVector));
        while (!groupsCurrent.isEmpty()) {
            GroupDetail group = (GroupDetail)groupsCurrent.remove(groupsCurrent.size() - 1);
            String groupId = group.getSpecificId();
            if (groupsDone.containsKey(groupId)) continue;
            groupsDone.put(groupId, group);
            groupsVector = this.getGroups(lds, groupId, extraFilter);
            groupsCurrent.addAll(Arrays.asList(groupsVector));
        }
        return groupsDone.values().toArray(new GroupDetail[0]);
    }

    public GroupDetail[] getGroups(String lds, String parentId, String extraFilter) throws AdminException {
        ArrayList<GroupDetail> groupsReturned = new ArrayList<GroupDetail>();
        ArrayList<LDAPEntry> groupMerged = new ArrayList<LDAPEntry>();
        if (parentId == null) {
            SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "Recherche des groupes racine du domaine LDAP distant...");
        } else {
            SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "Recherche des groupes fils inclus au groupe " + parentId + " du domaine LDAP distant...");
        }
        LDAPEntry[] groupsFounded = this.getChildGroupsEntry(lds, parentId, extraFilter);
        SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "groupsFounded=" + groupsFounded.length);
        GroupDetail[] groupsProcessed = new GroupDetail[groupsFounded.length];
        int i = -1;
        while (++i < groupsFounded.length) {
            int cpt = i;
            boolean groupSplit = false;
            if (i + 1 < groupsFounded.length) {
                String firstGroupSplit = groupsFounded[i].getDN();
                while (i + 1 < groupsFounded.length && firstGroupSplit.equals(groupsFounded[++cpt].getDN())) {
                    groupSplit = true;
                    groupMerged.add(groupsFounded[cpt - 1]);
                    ++i;
                }
            }
            this.translateGroup(lds, groupMerged, groupsFounded, groupsProcessed, i, cpt, groupSplit);
            groupsReturned.add(groupsProcessed[i]);
            this.reportGroupProcessed(parentId, groupsProcessed[i], i);
        }
        if (parentId == null) {
            SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "R\u00e9cup\u00e9ration de " + groupsFounded.length + " groupes racine du domaine LDAP distant");
        } else {
            SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "R\u00e9cup\u00e9ration de " + groupsFounded.length + " groupes fils du groupe " + parentId);
        }
        return groupsReturned.toArray(new GroupDetail[0]);
    }

    private void reportGroupProcessed(String parentId, GroupDetail groupDetail, int i) {
        if (groupDetail != null) {
            SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, "groupsReturned[" + i + "]" + groupDetail.getSpecificId() + " - " + groupDetail.getName());
            String strTypeGroup = parentId == null ? "Groupe racine" : "Groupe fils";
            if (groupDetail.getUserIds().length != 0) {
                SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, strTypeGroup + " trouv\u00e9 no : " + i + ", nom du groupe : " + groupDetail.getSpecificId() + ", desc. : " + groupDetail.getDescription() + ". " + groupDetail.getUserIds().length + " utilisateur(s) membre(s) associ\u00e9(s)");
            } else {
                SynchroDomainReport.debug(LDAPGROUP_GET_GROUPS, strTypeGroup + " trouv\u00e9 no : " + i + ", nom du groupe : " + groupDetail.getSpecificId() + ", desc. : " + groupDetail.getDescription());
            }
        }
    }

    private void translateGroup(String lds, List<LDAPEntry> groupMerged, LDAPEntry[] groupsFounded, GroupDetail[] groupsProcessed, int i, int cpt, boolean groupSplitted) throws AdminException {
        if (groupSplitted) {
            groupMerged.add(groupsFounded[cpt - 1]);
            groupsProcessed[i] = this.translateGroups(lds, groupMerged);
            groupMerged.clear();
        } else {
            groupsProcessed[i] = this.translateGroup(lds, groupsFounded[i]);
        }
    }

    public GroupDetail getGroup(String lds, String id) throws AdminException {
        return this.getGroupDetail(lds, id, this::getGroupEntry);
    }

    public GroupDetail getGroupByName(String lds, String name) throws AdminException {
        return this.getGroupDetail(lds, name, this::getGroupEntryByName);
    }

    private GroupDetail getGroupDetail(String ldap, String group, LdapGroupSupplier ldapEntrySupplier) throws AdminException {
        LDAPEntry theEntry = null;
        try {
            theEntry = ldapEntrySupplier.get(ldap, group);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
                this.synchroReport.append("PB getting GroupDetail : ").append(group).append("\n");
            }
            throw e;
        }
        return this.translateGroup(ldap, theEntry);
    }

    protected GroupDetail translateGroup(String lds, LDAPEntry groupEntry) throws AdminException {
        GroupDetail groupInfos = new GroupDetail();
        if (groupEntry == null) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"LDAP group entry"), new String[0]);
        }
        this.fillGroupDetail(groupInfos, groupEntry);
        try {
            groupInfos.setUserIds(this.getUserIds(lds, groupEntry));
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
                this.synchroReport.append("PB getting GroupDetail's childs : ").append(groupInfos.getName()).append("\n");
                SynchroDomainReport.error("AbstractLDAPGroup.translateGroup()", "Pb de r\u00e9cup\u00e9ration des membres utilisateurs du groupe " + groupInfos.getSpecificId(), (Throwable)((Object)e));
            }
            throw e;
        }
        return groupInfos;
    }

    protected GroupDetail translateGroups(String lds, List<LDAPEntry> groupEntries) throws AdminException {
        GroupDetail groupInfos = new GroupDetail();
        ArrayList allUserIds = new ArrayList();
        if (groupEntries.isEmpty()) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"LDAP group entries"), new String[0]);
        }
        boolean first = true;
        for (LDAPEntry groupEntry : groupEntries) {
            if (first) {
                this.fillGroupDetail(groupInfos, groupEntry);
                first = false;
            }
            try {
                String[] userIds = this.getUserIds(lds, groupEntry);
                SynchroDomainReport.info(LDAPGROUP_TRANSLATE_GROUPS, "Users in group: " + userIds.length);
                Collections.addAll(allUserIds, userIds);
            }
            catch (AdminException e) {
                if (this.synchroInProcess) {
                    SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
                    this.synchroReport.append("PB getting GroupDetail's children: ").append(groupInfos.getName()).append("\n");
                    SynchroDomainReport.error(LDAPGROUP_TRANSLATE_GROUPS, "Pb de r\u00e9cup\u00e9ration des membres utilisateurs du groupe " + groupInfos.getSpecificId(), (Throwable)((Object)e));
                    continue;
                }
                throw e;
            }
        }
        groupInfos.setUserIds(allUserIds.toArray(new String[0]));
        SynchroDomainReport.debug(LDAPGROUP_TRANSLATE_GROUPS, "Users in merged GroupDetail: " + groupInfos.getDirectUsersCount());
        return groupInfos;
    }

    private void fillGroupDetail(GroupDetail groupInfos, LDAPEntry groupEntry) {
        groupInfos.setSpecificId(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsIdField()));
        groupInfos.setName(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsNameField()));
        groupInfos.setDescription(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsDescriptionField()));
    }

    public abstract String[] getGroupMemberGroupIds(String var1, String var2) throws AdminException;

    public abstract String[] getUserMemberGroupIds(String var1, String var2) throws AdminException;

    protected abstract String[] getUserIds(String var1, LDAPEntry var2) throws AdminException;

    protected abstract LDAPEntry[] getChildGroupsEntry(String var1, String var2, String var3) throws AdminException;

    protected LDAPEntry getGroupEntry(String lds, String groupId) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(groupId), this.driverSettings.getGroupAttributes());
    }

    protected LDAPEntry getGroupEntryByName(String lds, String groupName) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsNameFilter(groupName), this.driverSettings.getGroupAttributes());
    }

    protected LDAPEntry getMemberEntry(String lds, String memberId, boolean isGroup) throws AdminException {
        LDAPEntry memberEntry = isGroup ? LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(memberId), this.driverSettings.getGroupAttributes()) : LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(memberId), this.driverSettings.getGroupAttributes());
        if (memberEntry == null) {
            throw new AdminException(SilverpeasExceptionMessages.unknown((String)"LDAP group id", (Object)memberId), new String[0]);
        }
        return memberEntry;
    }

    protected String getSpecificId(String lds, LDAPEntry theEntry) throws AdminException {
        if (theEntry != null) {
            String userSpecificId = LDAPUtility.getFirstAttributeValue(theEntry, this.driverSettings.getUsersIdField());
            if (LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(userSpecificId), this.driverSettings.getGroupAttributes()) != null) {
                return userSpecificId;
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface LdapGroupSupplier {
        public LDAPEntry get(String var1, String var2) throws AdminException;
    }
}

