/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.googledriver;

import com.google.api.services.directory.model.User;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.driver.googledriver.GoogleDirectoryRequester;
import org.silverpeas.core.admin.domain.driver.googledriver.GoogleEntitySimpleAttributePathResolver;
import org.silverpeas.core.admin.domain.driver.googledriver.GoogleUserFilterManager;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class GoogleDriver
extends AbstractDomainDriver {
    private static final String ATTRIBUTE_PATH_MSG_ERROR = "Verify the attribute path to access entity data, it must target a single value";
    protected SettingBundle settings;
    private DomainDriver.UserFilterManager userFilterManager;
    private final Function<User, UserDetail> userDetailMapper = u -> {
        UserDetail user = new UserDetail();
        this.setCommonUserProps((User)u, user);
        return user;
    };
    private final Function<User, UserFull> userFullMapper = u -> {
        String[] specificProps;
        UserFull user = new UserFull(this);
        this.setCommonUserProps((User)u, user);
        for (String specificProp : specificProps = this.getPropertiesNames()) {
            DomainProperty property = this.getProperty(specificProp);
            String googleEntityAttributePath = property.getMapParameter();
            String value = (String)GoogleEntitySimpleAttributePathResolver.resolve(u, googleEntityAttributePath);
            user.setValue(property.getName(), value);
        }
        return user;
    };

    @Override
    public void initFromProperties(SettingBundle rs) {
        this.settings = rs;
        this.userFilterManager = new GoogleUserFilterManager(this, rs);
    }

    @Override
    public long getDriverActions() {
        return 1025L;
    }

    @Override
    public boolean isSynchroThreaded() {
        return this.settings.getBoolean("synchro.Threaded", false);
    }

    @Override
    public UserDetail importUser(String userLogin) {
        return null;
    }

    @Override
    public void removeUser(String userId) {
    }

    @Override
    public UserDetail synchroUser(String userId) throws AdminException {
        return this.getUser(userId);
    }

    @Override
    public String createUser(UserDetail user) {
        return null;
    }

    @Override
    public void deleteUser(String userId) {
    }

    @Override
    public void updateUserFull(UserFull user) {
    }

    @Override
    public void updateUserDetail(UserDetail user) {
    }

    @Override
    public UserFull getUserFull(String specificId) throws AdminException {
        try {
            return Optional.ofNullable(this.request().user(specificId)).map(this.userFullMapper).orElse(null);
        }
        catch (ClassCastException e) {
            throw new AdminException(ATTRIBUTE_PATH_MSG_ERROR, e);
        }
    }

    @Override
    public List<UserFull> listUserFulls(Collection<String> specificIds) throws AdminException {
        try {
            if (specificIds.size() == 1) {
                return Collections.singletonList(this.getUserFull(specificIds.iterator().next()));
            }
            return this.request().users().stream().map(this.userFullMapper).filter(u -> specificIds.contains(u.getSpecificId())).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new AdminException(ATTRIBUTE_PATH_MSG_ERROR, e);
        }
    }

    @Override
    public UserDetail getUser(String specificId) throws AdminException {
        return this.userDetailMapper.apply(this.request().user(specificId));
    }

    @Override
    public List<UserDetail> listUsers(Collection<String> specificIds) throws AdminException {
        if (specificIds.size() == 1) {
            return Collections.singletonList(this.getUser(specificIds.iterator().next()));
        }
        return Arrays.stream(this.getAllUsers()).filter(u -> specificIds.contains(u.getSpecificId())).collect(Collectors.toList());
    }

    @Override
    public UserDetail[] getAllUsers() throws AdminException {
        return (UserDetail[])this.request().users().stream().map(this.userDetailMapper).toArray(UserDetail[]::new);
    }

    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return new UserDetail[0];
        }
        String googleEntityAttributePath = property.getMapParameter();
        GoogleEntitySimpleAttributePathResolver.AttributePathDecoder attributePathDecoder = GoogleEntitySimpleAttributePathResolver.decodePath(googleEntityAttributePath);
        try {
            return (UserDetail[])this.request().users().stream().filter(u -> {
                String attributeValue = (String)GoogleEntitySimpleAttributePathResolver.resolve(u, attributePathDecoder);
                return StringUtil.likeIgnoreCase((String)attributeValue, (String)propertyValue);
            }).map(this.userDetailMapper).toArray(UserDetail[]::new);
        }
        catch (ClassCastException e) {
            throw new AdminException(ATTRIBUTE_PATH_MSG_ERROR, e);
        }
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) {
        return new UserDetail[0];
    }

    @Override
    public String[] getUserMemberGroupIds(String specificId) {
        return new String[0];
    }

    @Override
    public GroupDetail importGroup(String groupName) {
        return null;
    }

    @Override
    public void removeGroup(String groupId) {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) {
        return this.getGroup(groupId);
    }

    @Override
    public String createGroup(GroupDetail group) {
        return null;
    }

    @Override
    public void deleteGroup(String groupId) {
    }

    @Override
    public void updateGroup(GroupDetail group) {
    }

    @Override
    public GroupDetail getGroup(String specificId) {
        return null;
    }

    @Override
    public GroupDetail getGroupByName(String groupName) {
        return null;
    }

    @Override
    public GroupDetail[] getGroups(String groupId) {
        return new GroupDetail[0];
    }

    @Override
    public GroupDetail[] getAllGroups() {
        return new GroupDetail[0];
    }

    @Override
    public GroupDetail[] getAllRootGroups() {
        return this.getAllGroups();
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) {
        return new String[0];
    }

    @Override
    public List<String> getUserAttributes() {
        return Collections.emptyList();
    }

    @Override
    public void resetPassword(UserDetail user, String password) {
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) {
    }

    @Override
    public Optional<DomainDriver.UserFilterManager> getUserFilterManager() {
        return Optional.of(this.userFilterManager);
    }

    GoogleDirectoryRequester request() {
        return new GoogleDirectoryRequester(this.settings.getString("service.account.user"), this.settings.getString("service.account.jsonKey"), this.userFilterManager.getRule());
    }

    private void setCommonUserProps(User u, UserDetail user) {
        user.setSpecificId(u.getId());
        user.setLogin(u.getPrimaryEmail());
        user.setLastName(u.getName().getFamilyName());
        user.setFirstName(u.getName().getGivenName());
        List emails = (List)u.getEmails();
        String email = emails.stream().filter(m -> "Work".equalsIgnoreCase((String)m.get("type")) || "Work".equalsIgnoreCase((String)m.get("customType"))).map(m -> (String)m.get("address")).findFirst().orElseGet(() -> ((User)u).getPrimaryEmail());
        user.setEmailAddress(email);
        user.setAccessLevel(UserAccessLevel.USER);
        if (Boolean.TRUE.equals(u.getSuspended())) {
            user.setState(UserState.DEACTIVATED);
        } else {
            user.setState(UserState.VALID);
        }
    }
}

