/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.driver.SPGroup;
import org.silverpeas.core.admin.domain.driver.SPGroupRepository;
import org.silverpeas.core.admin.domain.driver.SPUser;
import org.silverpeas.core.admin.domain.driver.SPUserRepository;
import org.silverpeas.core.admin.domain.driver.SilverpeasDomainDriver;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.security.authentication.password.PasswordEncryption;
import org.silverpeas.core.security.authentication.password.PasswordEncryptionProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
@Service
public class SilverpeasDriver
extends AbstractDomainDriver
implements SilverpeasDomainDriver {
    private static final String TITLE = "title";
    private static final String COMPANY = "company";
    private static final String POSITION = "position";
    private static final String BOSS = "boss";
    private static final String PHONE = "phone";
    private static final String HOME_PHONE = "homePhone";
    private static final String FAX = "fax";
    private static final String CELLULAR_PHONE = "cellularPhone";
    private static final String ADDRESS = "address";
    @Inject
    private SPUserRepository spUserRepository;
    @Inject
    private SPGroupRepository spGroupRepository;

    protected SilverpeasDriver() {
    }

    @Override
    public void initFromProperties(SettingBundle rs) throws AdminException {
    }

    @Override
    public UserDetail importUser(String userLogin) throws AdminException {
        return null;
    }

    @Override
    public void removeUser(String userId) throws AdminException {
    }

    @Override
    public UserDetail synchroUser(String userId) throws AdminException {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createUser(UserDetail ud) {
        try {
            SPUser user = this.convertToSPUser(ud, new SPUser());
            user = (SPUser)this.spUserRepository.saveAndFlush((IdentifiableEntity)user);
            return user.getId();
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            return "-1";
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteUser(String userId) {
        if (StringUtil.isInteger((String)userId)) {
            SPUser user = (SPUser)this.spUserRepository.getById(userId);
            if (user.getGroups() != null) {
                for (SPGroup group : user.getGroups()) {
                    group.getUsers().remove(user);
                    this.spGroupRepository.saveAndFlush(group);
                }
            }
            this.spUserRepository.delete((IdentifiableEntity[])new SPUser[]{user});
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserFull(UserFull userFull) {
        SPUser oldUser = (SPUser)this.spUserRepository.getById(userFull.getSpecificId());
        oldUser.setFirstname(userFull.getFirstName());
        oldUser.setLastname(userFull.getLastName());
        oldUser.setLogin(userFull.getLogin());
        oldUser.setEmail(userFull.getEmailAddress());
        oldUser.setTitle(userFull.getValue(TITLE));
        oldUser.setCompany(userFull.getValue(COMPANY));
        oldUser.setPosition(userFull.getValue(POSITION));
        oldUser.setBoss(userFull.getValue(BOSS));
        oldUser.setPhone(userFull.getValue(PHONE));
        oldUser.setHomephone(userFull.getValue(HOME_PHONE));
        oldUser.setFax(userFull.getValue(FAX));
        oldUser.setCellphone(userFull.getValue(CELLULAR_PHONE));
        oldUser.setAddress(userFull.getValue(ADDRESS));
        oldUser.setLoginmail("");
        if (StringUtil.isDefined((String)userFull.getPassword()) && !userFull.getPassword().equals(oldUser.getPassword())) {
            oldUser.setPassword(this.encrypt(userFull.getPassword()));
        }
        oldUser.setPasswordValid(userFull.isPasswordValid());
        this.spUserRepository.saveAndFlush((IdentifiableEntity)oldUser);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserDetail(UserDetail ud) {
        SPUser user;
        if (StringUtil.isInteger((String)ud.getSpecificId()) && (user = (SPUser)this.spUserRepository.getById(ud.getSpecificId())) != null) {
            this.spUserRepository.save((IdentifiableEntity)this.convertToSPUser(ud, user));
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail getUser(String specificId) {
        if (!StringUtil.isInteger((String)specificId)) {
            return null;
        }
        return (UserDetail)JdbcSqlQuery.unique(this.listUsers(Collections.singleton(specificId)));
    }

    @Override
    public List<UserDetail> listUsers(Collection<String> specificIds) {
        return this.spUserRepository.getById(specificIds).stream().map(u -> this.convertToUser((SPUser)u, new UserDetail())).collect(Collectors.toList());
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserFull getUserFull(String specificId) throws AdminException {
        if (!StringUtil.isInteger((String)specificId)) {
            return null;
        }
        return this.listUserFulls(Collections.singleton(specificId)).stream().findFirst().orElseGet(() -> new UserFull(this));
    }

    @Override
    public List<UserFull> listUserFulls(Collection<String> specificIds) throws AdminException {
        Map<String, SPUser> domainUsersBySpecificId;
        try {
            domainUsersBySpecificId = JdbcSqlQuery.streamBySplittingOn(specificIds, idBatch -> this.spUserRepository.getById(idBatch)).collect(Collectors.toMap(AbstractJpaEntity::getId, u -> u));
        }
        catch (SQLException e) {
            throw new AdminException(e);
        }
        return specificIds.stream().map(domainUsersBySpecificId::get).map(u -> {
            UserFull userFull = new UserFull(this);
            if (u != null) {
                userFull.setSpecificId(u.getId());
                userFull.setFirstName(u.getFirstname());
                userFull.setLastName(u.getLastname());
                userFull.setValue(TITLE, u.getTitle());
                userFull.setValue(COMPANY, u.getCompany());
                userFull.setValue(POSITION, u.getPosition());
                userFull.setValue(BOSS, u.getBoss());
                userFull.setValue(PHONE, u.getPhone());
                userFull.setValue(HOME_PHONE, u.getHomephone());
                userFull.setValue(FAX, u.getFax());
                userFull.setValue(CELLULAR_PHONE, u.getCellphone());
                userFull.setValue(ADDRESS, u.getAddress());
                userFull.setLogin(u.getLogin());
                userFull.setEmailAddress(u.getEmail());
                userFull.setPassword(u.getPassword());
                userFull.setPasswordValid(u.isPasswordValid());
                userFull.setPasswordAvailable(true);
            }
            return userFull;
        }).collect(Collectors.toList());
    }

    @Override
    public String[] getUserMemberGroupIds(String specificId) throws AdminException {
        return new String[0];
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getAllUsers() {
        SilverpeasList users = this.spUserRepository.getAll();
        ArrayList<UserDetail> details = new ArrayList<UserDetail>(users.size());
        for (SPUser sPUser : users) {
            details.add(this.convertToUser(sPUser, new UserDetail()));
        }
        return details.toArray(new UserDetail[0]);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return new UserDetail[0];
        }
        List<Object> users = new ArrayList();
        if (TITLE.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByTitle(propertyValue);
        } else if (COMPANY.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByCompany(propertyValue);
        } else if (POSITION.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByPosition(propertyValue);
        } else if (PHONE.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByPhone(propertyValue);
        } else if (HOME_PHONE.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByHomephone(propertyValue);
        } else if (FAX.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByFax(propertyValue);
        } else if (CELLULAR_PHONE.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByCellphone(propertyValue);
        } else if (ADDRESS.equalsIgnoreCase(propertyName)) {
            users = this.spUserRepository.findByAddress(propertyValue);
        }
        ArrayList<UserDetail> userDetails = new ArrayList<UserDetail>(users.size());
        for (SPUser spUser : users) {
            userDetails.add(this.convertToUser(spUser, new UserDetail()));
        }
        return userDetails.toArray(new UserDetail[0]);
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws AdminException {
        return new UserDetail[0];
    }

    @Override
    public GroupDetail importGroup(String groupName) throws AdminException {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws AdminException {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) throws AdminException {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createGroup(GroupDetail group) {
        String[] userIds;
        SPGroup spGroup = new SPGroup();
        int id = DBUtil.getNextId((String)"domainsp_group", (String)"id");
        spGroup.setId(id);
        group.setId(String.valueOf(id));
        spGroup.setDescription(group.getDescription());
        spGroup.setName(group.getName());
        if (StringUtil.isInteger((String)group.getSuperGroupId())) {
            SPGroup parent = (SPGroup)this.spGroupRepository.getById(group.getSuperGroupId());
            spGroup.setParent(parent);
        }
        for (String userId : userIds = group.getUserIds()) {
            SPUser user = (SPUser)this.spUserRepository.getById(userId);
            spGroup.getUsers().add(user);
            user.getGroups().add(spGroup);
        }
        spGroup = this.spGroupRepository.saveAndFlush(spGroup);
        return String.valueOf(spGroup.getId());
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteGroup(String groupId) {
        SPGroup group = (SPGroup)this.spGroupRepository.getById(groupId);
        if (group != null) {
            for (SPGroup sPGroup : new ArrayList<SPGroup>(group.getSubGroups())) {
                this.deleteGroup(String.valueOf(sPGroup.getId()));
            }
            SPGroup reloadedGroup = (SPGroup)this.spGroupRepository.getById(groupId);
            for (SPUser user : new ArrayList<SPUser>(reloadedGroup.getUsers())) {
                user.getGroups().remove(reloadedGroup);
            }
            SPGroup sPGroup = reloadedGroup.getParent();
            if (sPGroup != null) {
                sPGroup.getSubGroups().remove(reloadedGroup);
                this.spGroupRepository.saveAndFlush(sPGroup);
            }
            this.spGroupRepository.delete((IdentifiableEntity[])new SPGroup[]{reloadedGroup});
            this.spGroupRepository.flush();
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateGroup(GroupDetail group) throws AdminException {
        String[] userIds;
        HashSet<SPUser> addedUsers = new HashSet<SPUser>();
        if (group == null || !StringUtil.isDefined((String)group.getName()) || !StringUtil.isDefined((String)group.getId())) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"group"), new String[0]);
        }
        SPGroup gr = this.convertToSPGroup(group, (SPGroup)this.spGroupRepository.getById(group.getSpecificId()));
        Set<SPUser> users = gr.getUsers();
        HashMap<String, SPUser> existingUsers = new HashMap<String, SPUser>(users.size());
        for (SPUser user : users) {
            existingUsers.put(String.valueOf(user.getId()), user);
        }
        for (String userId : userIds = group.getUserIds()) {
            if (existingUsers.containsKey(userId)) {
                addedUsers.add((SPUser)existingUsers.get(userId));
                existingUsers.remove(userId);
                continue;
            }
            SPUser newUser = (SPUser)this.spUserRepository.getById(userId);
            addedUsers.add(newUser);
        }
        gr.setUsers(addedUsers);
        this.spGroupRepository.saveAndFlush(gr);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail getGroup(String specificId) {
        SPGroup gr = (SPGroup)this.spGroupRepository.getById(specificId);
        return this.convertToGroup(gr);
    }

    @Override
    public GroupDetail getGroupByName(String groupName) throws AdminException {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getGroups(String groupId) {
        SPGroup gr = (SPGroup)this.spGroupRepository.getById(groupId);
        Set<SPGroup> subGroups = gr.getSubGroups();
        ArrayList<GroupDetail> groups = new ArrayList<GroupDetail>(subGroups.size());
        for (SPGroup spGroup : subGroups) {
            groups.add(this.convertToGroup(spGroup));
        }
        return groups.toArray(new GroupDetail[0]);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllGroups() {
        SilverpeasList groups = this.spGroupRepository.getAll();
        ArrayList<GroupDetail> result = new ArrayList<GroupDetail>(groups.size());
        for (SPGroup spGroup : groups) {
            result.add(this.convertToGroup(spGroup));
        }
        return result.toArray(new GroupDetail[0]);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllRootGroups() {
        List<SPGroup> groups = this.spGroupRepository.listAllRootGroups();
        ArrayList<GroupDetail> result = new ArrayList<GroupDetail>(groups.size());
        for (SPGroup spGroup : groups) {
            result.add(this.convertToGroup(spGroup));
        }
        return result.toArray(new GroupDetail[0]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws AdminException {
        return new String[0];
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void addUserInGroup(String userId, String groupId) {
        SPUser user = (SPUser)this.spUserRepository.getById(userId);
        SPGroup group = (SPGroup)this.spGroupRepository.getById(groupId);
        user.getGroups().add(group);
        group.getUsers().add(user);
        this.spGroupRepository.saveAndFlush(group);
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void removeUserFromGroup(String userId, String groupId) {
        SPUser user = (SPUser)this.spUserRepository.getById(userId);
        SPGroup group = (SPGroup)this.spGroupRepository.getById(groupId);
        user.getGroups().remove(group);
        group.getUsers().remove(user);
        this.spGroupRepository.saveAndFlush(group);
    }

    private SPGroup convertToSPGroup(GroupDetail group, SPGroup spGroup) {
        if (StringUtil.isDefined((String)group.getSpecificId()) && StringUtil.isInteger((String)group.getSpecificId())) {
            spGroup.setId(Integer.valueOf(group.getSpecificId()));
        }
        if (StringUtil.isDefined((String)group.getSuperGroupId()) && StringUtil.isInteger((String)group.getSuperGroupId())) {
            SPGroup parent = (SPGroup)this.spGroupRepository.getById(group.getSuperGroupId());
            spGroup.setParent(parent);
        }
        spGroup.setName(group.getName());
        spGroup.setDescription(group.getDescription());
        return spGroup;
    }

    private GroupDetail convertToGroup(SPGroup gr) {
        GroupDetail group = new GroupDetail();
        group.setSpecificId(String.valueOf(gr.getId()));
        group.setName(gr.getName());
        group.setDescription(gr.getDescription());
        if (gr.getParent() != null) {
            group.setSuperGroupId(String.valueOf(gr.getParent().getId()));
        }
        Set<SPUser> users = gr.getUsers();
        ArrayList<String> userIds = new ArrayList<String>(users.size());
        for (SPUser user : users) {
            userIds.add(String.valueOf(user.getId()));
        }
        group.setUserIds(userIds.toArray(new String[0]));
        return group;
    }

    @Override
    public List<String> getUserAttributes() throws AdminException {
        return Collections.emptyList();
    }

    private SPUser convertToSPUser(UserDetail detail, SPUser user) {
        if (StringUtil.isDefined((String)detail.getSpecificId()) && StringUtil.isInteger((String)detail.getSpecificId())) {
            user.setId(Integer.valueOf(detail.getId()));
        }
        user.setFirstname(detail.getFirstName());
        user.setLastname(detail.getLastName());
        user.setLogin(detail.getLogin());
        user.setEmail(detail.getEmailAddress());
        return user;
    }

    private UserDetail convertToUser(SPUser user, UserDetail detail) {
        detail.setSpecificId(String.valueOf(user.getId()));
        detail.setFirstName(user.getFirstname());
        detail.setLastName(user.getLastname());
        detail.setLogin(user.getLogin());
        detail.setEmailAddress(user.getEmail());
        return detail;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetPassword(UserDetail userDetail, String password) throws AdminException {
        SPUser user = (SPUser)this.spUserRepository.getById(userDetail.getId());
        user.setPassword(this.encrypt(password));
        user.setPasswordValid(true);
        this.spUserRepository.saveAndFlush((IdentifiableEntity)user);
    }

    private String encrypt(String password) {
        PasswordEncryption encryption = PasswordEncryptionProvider.getDefaultPasswordEncryption();
        return encryption.encrypt(password);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetEncryptedPassword(UserDetail userDetail, String encryptedPassword) {
        SPUser user = (SPUser)this.spUserRepository.getById(userDetail.getId());
        user.setPassword(encryptedPassword);
        user.setPasswordValid(true);
        this.spUserRepository.saveAndFlush((IdentifiableEntity)user);
    }
}

